"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditBurnRateRuleFlyout = EditBurnRateRuleFlyout;
var _react = _interopRequireDefault(require("react"));
var _kibana_react = require("../../../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EditBurnRateRuleFlyout({
  refetchRules,
  rule,
  isEditRuleFlyoutOpen,
  setIsEditRuleFlyoutOpen
}) {
  const {
    triggersActionsUi: {
      getEditRuleFlyout: EditRuleFlyout
    }
  } = (0, _kibana_react.useKibana)().services;
  const handleSavedRule = async () => {
    refetchRules();
    setIsEditRuleFlyoutOpen(false);
  };
  const handleCloseRuleFlyout = async () => {
    setIsEditRuleFlyoutOpen(false);
  };
  return isEditRuleFlyoutOpen && rule ? /*#__PURE__*/_react.default.createElement(EditRuleFlyout, {
    initialRule: rule,
    onSave: handleSavedRule,
    onClose: handleCloseRuleFlyout
  }) : null;
}