"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSloBtn = CreateSloBtn;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _kibana_react = require("../../../../utils/kibana_react");
var _paths = require("../../../../../common/locators/paths");
var _use_capabilities = require("../../../../hooks/use_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CreateSloBtn() {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    hasWriteCapabilities
  } = (0, _use_capabilities.useCapabilities)();
  const handleClickCreateSlo = () => {
    navigateToUrl(basePath.prepend(_paths.paths.sloCreate));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": "slosPageCreateNewSloButton",
    disabled: !hasWriteCapabilities,
    fill: true,
    onClick: handleClickCreateSlo
  }, _i18n.i18n.translate('xpack.slo.sloList.pageHeader.create', {
    defaultMessage: 'Create SLO'
  }));
}