"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloCardItemBadges = SloCardItemBadges;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _slo_active_alerts_badge = require("../../../../components/slo/slo_status_badge/slo_active_alerts_badge");
var _use_url_search_state = require("../../hooks/use_url_search_state");
var _slo_badges = require("../badges/slo_badges");
var _slo_remote_badge = require("../badges/slo_remote_badge");
var _slo_rules_badge = require("../badges/slo_rules_badge");
var _slo_time_window_badge = require("../badges/slo_time_window_badge");
var _slo_tags_list = require("../common/slo_tags_list");
var _slo_card_item_instance_badge = require("./slo_card_item_instance_badge");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = _styledComponents.default.div`
  display: inline-block;
  margin-top: 5px;
`;
function SloCardItemBadges({
  slo,
  activeAlerts,
  rules,
  handleCreateRule
}) {
  const {
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  const onTagClick = (0, _react.useCallback)(tag => {
    onStateChange({
      kqlQuery: `slo.tags: "${tag}"`
    });
  }, [onStateChange]);
  return /*#__PURE__*/_react.default.createElement(Container, {
    onClick: evt => {
      evt.stopPropagation();
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    responsive: false,
    gutterSize: "xs",
    alignItems: "center",
    wrap: true
  }, !slo.summary ? /*#__PURE__*/_react.default.createElement(_slo_badges.LoadingBadges, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_slo_active_alerts_badge.SloActiveAlertsBadge, {
    slo: slo,
    activeAlerts: activeAlerts,
    viewMode: "compact"
  }), /*#__PURE__*/_react.default.createElement(_slo_card_item_instance_badge.SLOCardItemInstanceBadge, {
    slo: slo
  }), /*#__PURE__*/_react.default.createElement(_slo_rules_badge.SloRulesBadge, {
    rules: rules,
    onClick: handleCreateRule,
    isRemote: !!slo.remote
  }), /*#__PURE__*/_react.default.createElement(_slo_time_window_badge.SloTimeWindowBadge, {
    slo: slo,
    color: "default"
  }), /*#__PURE__*/_react.default.createElement(_slo_remote_badge.SloRemoteBadge, {
    slo: slo
  }), /*#__PURE__*/_react.default.createElement(_slo_tags_list.SloTagsList, {
    tags: slo.tags,
    numberOfTagsToDisplay: 1,
    color: "default",
    ignoreEmpty: true,
    onClick: onTagClick
  }))));
}