"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsForm = SettingsForm;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _lodash = require("lodash");
var _use_get_settings = require("./use_get_settings");
var _use_put_slo_settings = require("./use_put_slo_settings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SettingsForm() {
  const [useAllRemoteClusters, setUseAllRemoteClusters] = (0, _react.useState)(false);
  const [selectedRemoteClusters, setSelectedRemoteClusters] = (0, _react.useState)([]);
  const {
    http
  } = (0, _public2.useKibana)().services;
  const {
    data: currentSettings
  } = (0, _use_get_settings.useGetSettings)();
  const {
    mutateAsync: updateSettings
  } = (0, _use_put_slo_settings.usePutSloSettings)();
  const {
    data,
    loading
  } = (0, _public.useFetcher)(() => {
    return http === null || http === void 0 ? void 0 : http.get('/api/remote_clusters');
  }, [http]);
  (0, _react.useEffect)(() => {
    if (currentSettings) {
      setUseAllRemoteClusters(currentSettings.useAllRemoteClusters);
      setSelectedRemoteClusters(currentSettings.selectedRemoteClusters);
    }
  }, [currentSettings]);
  const onSubmit = async () => {
    updateSettings({
      settings: {
        useAllRemoteClusters,
        selectedRemoteClusters
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.slo.settingsForm.h3.sourceSettingsLabel', {
      defaultMessage: 'Source settings'
    })),
    description: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.slo.settingsForm.p.fetchSlosFromAllLabel', {
      defaultMessage: 'Fetch SLOs from all remote clusters.'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.slo.settingsForm.euiFormRow.useAllRemoteClustersLabel', {
      defaultMessage: 'Use all remote clusters'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: "",
    checked: useAllRemoteClusters,
    onChange: evt => setUseAllRemoteClusters(evt.target.checked)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.slo.settingsForm.h3.remoteSettingsLabel', {
      defaultMessage: 'Remote clusters'
    })),
    description: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.slo.settingsForm.select.fetchSlosFromAllLabel', {
      defaultMessage: 'Select remote clusters to fetch SLOs from.'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.slo.settingsForm.euiFormRow.select.selectRemoteClustersLabel', {
      defaultMessage: 'Select remote clusters'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: (data === null || data === void 0 ? void 0 : data.map(cluster => ({
      label: cluster.name,
      value: cluster.name
    }))) || [],
    selectedOptions: selectedRemoteClusters.map(cluster => ({
      label: cluster,
      value: cluster
    })),
    onChange: sels => {
      setSelectedRemoteClusters(sels.map(s => s.value));
    },
    isDisabled: useAllRemoteClusters
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isLoading: loading,
    "data-test-subj": "o11ySettingsFormCancelButton",
    onClick: () => {
      setUseAllRemoteClusters((currentSettings === null || currentSettings === void 0 ? void 0 : currentSettings.useAllRemoteClusters) || false);
      setSelectedRemoteClusters((currentSettings === null || currentSettings === void 0 ? void 0 : currentSettings.selectedRemoteClusters) || []);
    },
    isDisabled: (0, _lodash.isEqual)(currentSettings, {
      useAllRemoteClusters,
      selectedRemoteClusters
    })
  }, _i18n.i18n.translate('xpack.slo.settingsForm.euiButtonEmpty.cancelLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: loading,
    "data-test-subj": "o11ySettingsFormSaveButton",
    color: "primary",
    fill: true,
    onClick: () => onSubmit(),
    isDisabled: (0, _lodash.isEqual)(currentSettings, {
      useAllRemoteClusters,
      selectedRemoteClusters
    })
  }, _i18n.i18n.translate('xpack.slo.settingsForm.applyButtonEmptyLabel', {
    defaultMessage: 'Apply'
  }))))));
}