"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SlosOutdatedDefinitions = SlosOutdatedDefinitions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _header_menu = require("../../components/header_menu/header_menu");
var _kibana_react = require("../../utils/kibana_react");
var _use_license = require("../../hooks/use_license");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_capabilities = require("../../hooks/use_capabilities");
var _use_fetch_global_diagnosis = require("../../hooks/use_fetch_global_diagnosis");
var _use_fetch_slo_definitions = require("../../hooks/use_fetch_slo_definitions");
var _paths = require("../../../common/locators/paths");
var _slo_list_empty = require("../slos/components/slo_list_empty");
var _outdated_slo = require("./outdated_slo");
var _outdated_slo_search_bar = require("./outdated_slo_search_bar");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SlosOutdatedDefinitions() {
  const {
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    hasWriteCapabilities
  } = (0, _use_capabilities.useCapabilities)();
  const {
    data: globalDiagnosis
  } = (0, _use_fetch_global_diagnosis.useFetchSloGlobalDiagnosis)();
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  (0, _public.useBreadcrumbs)([{
    href: basePath.prepend(_paths.paths.slos),
    text: _i18n.i18n.translate('xpack.slo.breadcrumbs.slosLinkText', {
      defaultMessage: 'SLOs'
    }),
    deepLinkId: 'slo'
  }, {
    text: _i18n.i18n.translate('xpack.slo.breadcrumbs.slosOutdatedDefinitions', {
      defaultMessage: 'Outdated SLO Definitions'
    })
  }]);
  const [search, setSearch] = (0, _react.useState)('');
  const [activePage, setActivePage] = (0, _react.useState)(0);
  const [perPage, setPerPage] = (0, _react.useState)(10);
  const handlePerPageChange = perPageNumber => {
    setPerPage(perPageNumber);
    setActivePage(0);
  };
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const {
    isLoading,
    data,
    refetch
  } = (0, _use_fetch_slo_definitions.useFetchSloDefinitions)({
    name: search,
    includeOutdatedOnly: true,
    page: activePage + 1,
    perPage
  });
  const {
    total
  } = data !== null && data !== void 0 ? data : {
    total: 0
  };
  const hasRequiredWritePrivileges = !!(globalDiagnosis !== null && globalDiagnosis !== void 0 && globalDiagnosis.userPrivileges.write.has_all_requested) && hasWriteCapabilities;
  const hasPlatinumLicense = hasAtLeast('platinum') === true;
  const hasSlosAndHasPermissions = hasPlatinumLicense && hasRequiredWritePrivileges;
  const errors = !hasRequiredWritePrivileges ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.slo.slosOutdatedDefinitions.sloPermissionsError', {
    defaultMessage: 'You must have write permissions for SLOs to access this page'
  })) : !hasPlatinumLicense ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.slo.slosOutdatedDefinitions.licenseError', {
    defaultMessage: 'You must have atleast a platinum license to access this page'
  })) : null;
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "slosOutdatedDefinitions",
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.slo.slosOutdatedDefinitions.pageTitle', {
        defaultMessage: 'Outdated SLO Definitions'
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, null), !hasSlosAndHasPermissions ? errors : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.slo.slosOutdatedDefinitions.description', {
    defaultMessage: 'The following SLOs are from a previous version and need to either be reset to upgrade to the latest version OR deleted and removed from the system. When you reset the SLO, the transform will be updated to the latest version and the historical data will be regenerated from the source data.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_outdated_slo_search_bar.OutdatedSloSearchBar, {
    initialSearch: search,
    onRefresh: refetch,
    onSearch: setSearch
  })), !isLoading && total === 0 && /*#__PURE__*/_react.default.createElement(_slo_list_empty.SloListEmpty, null), !isLoading && total > 0 && data && data.results.map(slo => /*#__PURE__*/_react.default.createElement(_outdated_slo.OutdatedSlo, {
    slo: slo,
    onDelete: refetch,
    onReset: refetch
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !isLoading && data && /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    activePage: activePage,
    pageCount: Math.ceil(total / perPage),
    itemsPerPage: perPage,
    onChangePage: setActivePage,
    onChangeItemsPerPage: handlePerPageChange,
    itemsPerPageOptions: [10, 20, 50, 100]
  })));
}