"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCreateSLOFlyoutLazy = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _plugin_context = require("../../../context/plugin_context");
var _slo_form = require("./slo_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCreateSLOFlyoutLazy = ({
  core,
  plugins,
  observabilityRuleTypeRegistry,
  ObservabilityPageTemplate,
  isDev,
  kibanaVersion,
  isServerless,
  experimentalFeatures
}) => {
  return ({
    onClose,
    initialValues
  }) => {
    const queryClient = new _reactQuery.QueryClient();
    return /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
      services: {
        ...core,
        ...plugins,
        storage: new _public.Storage(localStorage),
        isDev,
        kibanaVersion,
        isServerless
      }
    }, /*#__PURE__*/_react.default.createElement(_plugin_context.PluginContext.Provider, {
      value: {
        isDev,
        observabilityRuleTypeRegistry,
        ObservabilityPageTemplate,
        experimentalFeatures
      }
    }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
      client: queryClient
    }, /*#__PURE__*/_react.default.createElement(_slo_form.SloAddFormFlyout, {
      onClose: onClose,
      initialValues: initialValues
    }))));
  };
};
exports.getCreateSLOFlyoutLazy = getCreateSLOFlyoutLazy;