"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDebouncedGetPreviewData = useDebouncedGetPreviewData;
var _lodash = require("lodash");
var _react = require("react");
var _use_get_preview_data = require("../../../hooks/use_get_preview_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDebouncedGetPreviewData(isIndicatorValid, indicator, range) {
  const serializedIndicator = JSON.stringify(indicator);
  const [indicatorState, setIndicatorState] = (0, _react.useState)(serializedIndicator);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const store = (0, _react.useCallback)((0, _lodash.debounce)(value => setIndicatorState(value), 800), []);
  (0, _react.useEffect)(() => {
    if (indicatorState !== serializedIndicator) {
      store(serializedIndicator);
    }
  }, [indicatorState, serializedIndicator, store]);
  return (0, _use_get_preview_data.useGetPreviewData)({
    isValid: isIndicatorValid,
    indicator: JSON.parse(indicatorState),
    range
  });
}