"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditFormObjectiveSection = SloEditFormObjectiveSection;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../constants");
var _slo_edit_form = require("./slo_edit_form");
var _slo_edit_form_objective_section_timeslices = require("./slo_edit_form_objective_section_timeslices");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloEditFormObjectiveSection() {
  var _defaultValues$timeWi;
  const {
    control,
    watch,
    getFieldState,
    setValue,
    formState: {
      defaultValues
    }
  } = (0, _reactHookForm.useFormContext)();
  const budgetingSelect = (0, _eui.useGeneratedHtmlId)({
    prefix: 'budgetingSelect'
  });
  const timeWindowTypeSelect = (0, _eui.useGeneratedHtmlId)({
    prefix: 'timeWindowTypeSelect'
  });
  const timeWindowSelect = (0, _eui.useGeneratedHtmlId)({
    prefix: 'timeWindowSelect'
  });
  const timeWindowType = watch('timeWindow.type');
  const indicator = watch('indicator.type');
  const [timeWindowTypeState, setTimeWindowTypeState] = (0, _react.useState)(defaultValues === null || defaultValues === void 0 ? void 0 : (_defaultValues$timeWi = defaultValues.timeWindow) === null || _defaultValues$timeWi === void 0 ? void 0 : _defaultValues$timeWi.type);

  /**
   * Two flow to handle: Create and Edit
   * On create: the default value is set to rolling & 30d (useForm)
   * When we change the window type (from rolling to calendar for example), we want to select a default duration (picking item 1 in the options)
   * If we don't, the select will show the option as selected, but the value is still the one from the previous window type, until the user manually changes the value
   *
   * On edit: the default value is set with the slo value
   * When we change the window type, we want to change the selected value as we do in the create flow, but we also want to fallback on the initial default value
   *
   */
  (0, _react.useEffect)(() => {
    if (timeWindowType === 'calendarAligned' && timeWindowTypeState !== timeWindowType) {
      var _defaultValues$timeWi2, _defaultValues$timeWi3, _defaultValues$timeWi4;
      setTimeWindowTypeState(timeWindowType);
      const exists = _constants.CALENDARALIGNED_TIMEWINDOW_OPTIONS.map(opt => opt.value).includes((_defaultValues$timeWi2 = defaultValues === null || defaultValues === void 0 ? void 0 : (_defaultValues$timeWi3 = defaultValues.timeWindow) === null || _defaultValues$timeWi3 === void 0 ? void 0 : _defaultValues$timeWi3.duration) !== null && _defaultValues$timeWi2 !== void 0 ? _defaultValues$timeWi2 : '');
      setValue('timeWindow.duration',
      // @ts-ignore
      exists ? defaultValues === null || defaultValues === void 0 ? void 0 : (_defaultValues$timeWi4 = defaultValues.timeWindow) === null || _defaultValues$timeWi4 === void 0 ? void 0 : _defaultValues$timeWi4.duration : _constants.CALENDARALIGNED_TIMEWINDOW_OPTIONS[1].value);
    } else if (timeWindowType === 'rolling' && timeWindowTypeState !== timeWindowType) {
      var _defaultValues$timeWi5, _defaultValues$timeWi6, _defaultValues$timeWi7;
      const exists = _constants.ROLLING_TIMEWINDOW_OPTIONS.map(opt => opt.value).includes((_defaultValues$timeWi5 = defaultValues === null || defaultValues === void 0 ? void 0 : (_defaultValues$timeWi6 = defaultValues.timeWindow) === null || _defaultValues$timeWi6 === void 0 ? void 0 : _defaultValues$timeWi6.duration) !== null && _defaultValues$timeWi5 !== void 0 ? _defaultValues$timeWi5 : '');
      setTimeWindowTypeState(timeWindowType);
      setValue('timeWindow.duration',
      // @ts-ignore
      exists ? defaultValues === null || defaultValues === void 0 ? void 0 : (_defaultValues$timeWi7 = defaultValues.timeWindow) === null || _defaultValues$timeWi7 === void 0 ? void 0 : _defaultValues$timeWi7.duration : _constants.ROLLING_TIMEWINDOW_OPTIONS[1].value);
    }
  }, [timeWindowType, setValue, defaultValues, timeWindowTypeState]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none",
    style: {
      maxWidth: _slo_edit_form.maxWidth
    },
    "data-test-subj": "sloEditFormObjectiveSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.slo.sloEdit.timeWindowType.label', {
      defaultMessage: 'Time window'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.timeWindowType.tooltip', {
        defaultMessage: 'Choose between a rolling or a calendar aligned window.'
      }),
      position: "top"
    }))
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "timeWindow.type",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field: {
        ref,
        ...field
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({}, field, {
      required: true,
      id: timeWindowTypeSelect,
      "data-test-subj": "sloFormTimeWindowTypeSelect",
      options: _constants.TIMEWINDOW_TYPE_OPTIONS,
      value: field.value
    }))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.slo.sloEdit.timeWindowDuration.label', {
      defaultMessage: 'Duration'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.timeWindowDuration.tooltip', {
        defaultMessage: 'The time window duration used to compute the SLO over.'
      }),
      position: "top"
    }))
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "timeWindow.duration",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field: {
        ref,
        ...field
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({}, field, {
      required: true,
      id: timeWindowSelect,
      "data-test-subj": "sloFormTimeWindowDurationSelect",
      options: timeWindowType === 'calendarAligned' ? _constants.CALENDARALIGNED_TIMEWINDOW_OPTIONS : _constants.ROLLING_TIMEWINDOW_OPTIONS,
      value: field.value
    }))
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), indicator === 'sli.metric.timeslice' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEdit.sliType.timesliceMetric.objectiveMessage",
    defaultMessage: "The timeslice metric requires the budgeting method to be set to 'Timeslices' due to the nature of the statistical aggregations. The 'timeslice target' is also ignored in favor of the 'threshold' set in the metric definition above. The 'timeslice window' will set the size of the window the aggregation is performed on."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), indicator === 'sli.synthetics.availability' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEdit.sliType.syntheticAvailability.objectiveMessage",
    defaultMessage: "The Synthetics availability indicator requires the budgeting method to be set to 'Occurrences'."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.slo.sloEdit.budgetingMethod.label', {
      defaultMessage: 'Budgeting method'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.budgetingMethod.tooltip', {
        defaultMessage: 'Occurrences-based SLO uses the ratio of good events over the total events during the time window. Timeslices-based SLO uses the ratio of good time slices over the total time slices during the time window.'
      }),
      position: "top"
    }))
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "budgetingMethod",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field: {
        ref,
        ...field
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({}, field, {
      disabled: indicator === 'sli.metric.timeslice' || indicator === 'sli.synthetics.availability',
      required: true,
      id: budgetingSelect,
      "data-test-subj": "sloFormBudgetingMethodSelect",
      options: _constants.BUDGETING_METHOD_OPTIONS
    }))
  }))), watch('budgetingMethod') === 'timeslices' ? /*#__PURE__*/_react.default.createElement(_slo_edit_form_objective_section_timeslices.SloEditFormObjectiveSectionTimeslices, null) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: getFieldState('objective.target').invalid,
    label: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.slo.sloEdit.targetSlo.label', {
      defaultMessage: 'Target / SLO (%)'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.targetSlo.tooltip', {
        defaultMessage: 'The target objective in percentage for the SLO.'
      }),
      position: "top"
    }))
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "objective.target",
    control: control,
    rules: {
      required: true,
      min: 0.001,
      max: 99.999
    },
    render: ({
      field: {
        ref,
        onChange,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, field, {
      required: true,
      isInvalid: fieldState.invalid,
      "data-test-subj": "sloFormObjectiveTargetInput",
      value: field.value,
      min: 0.001,
      max: 99.999,
      step: 0.001,
      onChange: event => onChange(event.target.value)
    }))
  })))));
}