"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditFormFooter = SloEditFormFooter;
exports.maxWidth = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _reactReversePortal = require("react-reverse-portal");
var _public = require("@kbn/observability-plugin/public");
var _kibana_react = require("../../../utils/kibana_react");
var _slo_add_form_flyout = require("../shared_flyout/slo_add_form_flyout");
var _paths = require("../../../../common/locators/paths");
var _use_create_slo = require("../../../hooks/use_create_slo");
var _use_update_slo = require("../../../hooks/use_update_slo");
var _create_burn_rate_rule_request_body = require("../helpers/create_burn_rate_rule_request_body");
var _process_slo_form_values = require("../helpers/process_slo_form_values");
var _equivalent_api_request = require("./common/equivalent_api_request");
var _slo_inspect = require("./common/slo_inspect");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maxWidth = exports.maxWidth = 775;
function SloEditFormFooter({
  slo,
  onSave
}) {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const isEditMode = slo !== undefined;
  const {
    getValues,
    trigger
  } = (0, _reactHookForm.useFormContext)();
  const {
    mutateAsync: createSlo,
    isLoading: isCreateSloLoading
  } = (0, _use_create_slo.useCreateSlo)();
  const {
    mutateAsync: updateSlo,
    isLoading: isUpdateSloLoading
  } = (0, _use_update_slo.useUpdateSlo)();
  const {
    mutateAsync: createBurnRateRule,
    isLoading: isCreateBurnRateRuleLoading
  } = (0, _public.useCreateRule)();
  const navigate = (0, _react.useCallback)(url => setTimeout(() => navigateToUrl(url)), [navigateToUrl]);
  const isFlyout = Boolean(onSave);
  const handleSubmit = (0, _react.useCallback)(async () => {
    const isValid = await trigger();
    if (!isValid) {
      return;
    }
    const values = getValues();
    if (isEditMode) {
      const processedValues = (0, _process_slo_form_values.transformValuesToUpdateSLOInput)(values);
      await updateSlo({
        sloId: slo.id,
        slo: processedValues
      });
      navigate(basePath.prepend(_paths.paths.slos));
    } else {
      const processedValues = (0, _process_slo_form_values.transformCreateSLOFormToCreateSLOInput)(values);
      const resp = await createSlo({
        slo: processedValues
      });
      await createBurnRateRule({
        rule: (0, _create_burn_rate_rule_request_body.createBurnRateRuleRequestBody)({
          ...processedValues,
          id: resp.id
        })
      });
      if (onSave) {
        onSave();
      } else {
        navigate(basePath.prepend(_paths.paths.slos));
      }
    }
  }, [basePath, createBurnRateRule, createSlo, getValues, isEditMode, navigate, onSave, slo === null || slo === void 0 ? void 0 : slo.id, trigger, updateSlo]);
  const content = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": "sloFormSubmitButton",
    fill: true,
    isLoading: isCreateSloLoading || isUpdateSloLoading || isCreateBurnRateRuleLoading,
    onClick: handleSubmit
  }, isEditMode ? _i18n.i18n.translate('xpack.slo.sloEdit.editSloButton', {
    defaultMessage: 'Update SLO'
  }) : _i18n.i18n.translate('xpack.slo.sloEdit.createSloButton', {
    defaultMessage: 'Create SLO'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    "data-test-subj": "sloFormCancelButton",
    disabled: isCreateSloLoading || isUpdateSloLoading || isCreateBurnRateRuleLoading,
    onClick: onSave ? () => onSave() : () => navigateToUrl(basePath.prepend(_paths.paths.slos))
  }, _i18n.i18n.translate('xpack.slo.sloEdit.cancelButton', {
    defaultMessage: 'Cancel'
  }))), !isFlyout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_equivalent_api_request.EquivalentApiRequest, {
    slo: slo,
    disabled: isCreateSloLoading || isUpdateSloLoading || isCreateBurnRateRuleLoading,
    isEditMode: isEditMode
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_slo_inspect.SLOInspectWrapper, {
    slo: slo,
    disabled: isCreateSloLoading || isUpdateSloLoading || isCreateBurnRateRuleLoading
  })))), [isCreateSloLoading, isUpdateSloLoading, isCreateBurnRateRuleLoading, handleSubmit, isEditMode, onSave, isFlyout, slo, navigateToUrl, basePath]);
  return isFlyout ? /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: _slo_add_form_flyout.sloEditFormFooterPortal
  }, content) : content;
}