"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexFieldSelector = IndexFieldSelector;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _create_options = require("../../helpers/create_options");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IndexFieldSelector({
  indexFields,
  name,
  label,
  labelAppend,
  placeholder,
  isDisabled,
  isLoading,
  isRequired = false,
  defaultValue = ''
}) {
  const {
    control,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const [options, setOptions] = (0, _react.useState)((0, _create_options.createOptionsFromFields)(indexFields));
  (0, _react.useEffect)(() => {
    setOptions((0, _create_options.createOptionsFromFields)(indexFields));
  }, [indexFields]);
  const getSelectedItems = (value, fields) => {
    const values = [value].flat();
    const selectedItems = [];
    fields.forEach(field => {
      if (values.includes(field.name)) {
        selectedItems.push({
          value: field.name,
          label: field.name
        });
      }
    });
    return selectedItems;
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    isInvalid: getFieldState(name).invalid,
    labelAppend: labelAppend
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    defaultValue: [defaultValue].flat(),
    name: name,
    control: control,
    rules: {
      required: isRequired && !isDisabled
    },
    render: ({
      field,
      fieldState
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
        async: true,
        placeholder: placeholder,
        "aria-label": placeholder,
        isClearable: true,
        isDisabled: isLoading || isDisabled,
        isInvalid: fieldState.invalid,
        isLoading: isLoading,
        onChange: selected => {
          if (selected.length) {
            return field.onChange(selected.map(selection => selection.value));
          }
          field.onChange(defaultValue);
        },
        options: options,
        onSearchChange: searchValue => {
          setOptions((0, _create_options.createOptionsFromFields)(indexFields, ({
            value
          }) => value.includes(searchValue)));
        },
        selectedOptions: !!indexFields && !!field.value ? getSelectedItems(field.value, indexFields) : []
      }));
    }
  })));
}