"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmLatencyIndicatorTypeForm = ApmLatencyIndicatorTypeForm;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _group_by_field = require("../common/group_by_field");
var _use_create_data_view = require("../../../../hooks/use_create_data_view");
var _use_fetch_apm_indices = require("../../../../hooks/use_fetch_apm_indices");
var _field_selector = require("../apm_common/field_selector");
var _data_preview_chart = require("../common/data_preview_chart");
var _query_builder = require("../common/query_builder");
var _format_filters = require("../../helpers/format_filters");
var _get_group_by_cardinality_filters = require("../apm_common/get_group_by_cardinality_filters");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ApmLatencyIndicatorTypeForm() {
  const {
    control,
    watch,
    getFieldState,
    setValue
  } = (0, _reactHookForm.useFormContext)();
  const {
    data: apmIndex
  } = (0, _use_fetch_apm_indices.useFetchApmIndex)();
  const [serviceName = '', environment = '', transactionType = '', transactionName = '', globalFilters] = watch(['indicator.params.service', 'indicator.params.environment', 'indicator.params.transactionType', 'indicator.params.transactionName', 'indicator.params.filter']);
  const indicatorParamsFilters = (0, _get_group_by_cardinality_filters.getGroupByCardinalityFilters)({
    serviceName,
    environment,
    transactionType,
    transactionName
  });
  const allFilters = (0, _format_filters.formatAllFilters)(globalFilters, indicatorParamsFilters);
  (0, _react.useEffect)(() => {
    if (apmIndex !== '') {
      setValue('indicator.params.index', apmIndex);
    }
  }, [setValue, apmIndex]);
  const {
    dataView,
    loading: isIndexFieldsLoading
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString: apmIndex
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    allowAllOption: false,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.apmLatency.serviceName', {
      defaultMessage: 'Service name'
    }),
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.apmLatency.serviceName.placeholder', {
      defaultMessage: 'Select the APM service'
    }),
    fieldName: "service.name",
    name: "indicator.params.service",
    dataTestSubj: "apmLatencyServiceSelector",
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.apm.serviceName.tooltip', {
        defaultMessage: 'This is the APM service monitored by this SLO.'
      }),
      position: "top"
    })
  }), /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    label: _i18n.i18n.translate('xpack.slo.sloEdit.apmLatency.serviceEnvironment', {
      defaultMessage: 'Service environment'
    }),
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.apmLatency.serviceEnvironment.placeholder', {
      defaultMessage: 'Select the environment'
    }),
    fieldName: "service.environment",
    name: "indicator.params.environment",
    dataTestSubj: "apmLatencyEnvironmentSelector"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    label: _i18n.i18n.translate('xpack.slo.sloEdit.apmLatency.transactionType', {
      defaultMessage: 'Transaction type'
    }),
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.apmLatency.transactionType.placeholder', {
      defaultMessage: 'Select the transaction type'
    }),
    fieldName: "transaction.type",
    name: "indicator.params.transactionType",
    dataTestSubj: "apmLatencyTransactionTypeSelector"
  }), /*#__PURE__*/_react.default.createElement(_field_selector.FieldSelector, {
    label: _i18n.i18n.translate('xpack.slo.sloEdit.apmLatency.transactionName', {
      defaultMessage: 'Transaction name'
    }),
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.apmLatency.transactionName.placeholder', {
      defaultMessage: 'Select the transaction name'
    }),
    fieldName: "transaction.name",
    name: "indicator.params.transactionName",
    dataTestSubj: "apmLatencyTransactionNameSelector"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.slo.sloEdit.apmLatency.threshold.placeholder', {
      defaultMessage: 'Threshold (ms)'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.apmLatency.threshold.tooltip', {
        defaultMessage: 'Configure the threshold in milliseconds defining the "good" or "successful" requests for the SLO.'
      }),
      position: "top"
    })),
    isInvalid: getFieldState('indicator.params.threshold').invalid
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "indicator.params.threshold",
    control: control,
    defaultValue: 250,
    rules: {
      required: true,
      min: 0
    },
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, field, {
      required: true,
      isInvalid: fieldState.invalid,
      value: String(field.value),
      "data-test-subj": "apmLatencyThresholdInput",
      min: 0,
      onChange: event => field.onChange(Number(event.target.value))
    }))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_builder.QueryBuilder, {
    dataTestSubj: "apmLatencyFilterInput",
    indexPatternString: watch('indicator.params.index'),
    label: _i18n.i18n.translate('xpack.slo.sloEdit.apmLatency.filter', {
      defaultMessage: 'Query filter'
    }),
    name: "indicator.params.filter",
    placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.apmLatency.filter.placeholder', {
      defaultMessage: 'Custom filter to apply on the index'
    }),
    tooltip: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.apm.filter.tooltip', {
        defaultMessage: 'This KQL query is used to filter the APM metrics on some relevant criteria for this SLO.'
      }),
      position: "top"
    })
  }))), /*#__PURE__*/_react.default.createElement(_group_by_field.GroupByField, {
    dataView: dataView,
    isLoading: isIndexFieldsLoading,
    filters: allFilters
  }), /*#__PURE__*/_react.default.createElement(_data_preview_chart.DataPreviewChart, null));
}