"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REMOTE_NAME_PARAM = exports.INSTANCE_SEARCH_PARAM = exports.DELETE_SLO = void 0;
exports.useGetQueryParams = useGetQueryParams;
var _sloSchema = require("@kbn/slo-schema");
var _reactRouterDom = require("react-router-dom");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INSTANCE_SEARCH_PARAM = exports.INSTANCE_SEARCH_PARAM = 'instanceId';
const REMOTE_NAME_PARAM = exports.REMOTE_NAME_PARAM = 'remoteName';
const DELETE_SLO = exports.DELETE_SLO = 'delete';
function useGetQueryParams() {
  const {
    search,
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();
  const searchParams = new URLSearchParams(search);
  const instanceId = searchParams.get(INSTANCE_SEARCH_PARAM);
  const remoteName = searchParams.get(REMOTE_NAME_PARAM);
  const deleteSlo = searchParams.get(DELETE_SLO);
  const removeDeleteQueryParam = (0, _react.useCallback)(() => {
    const qParams = new URLSearchParams(search);

    // remote delete param from url after initial load
    if (deleteSlo === 'true') {
      qParams.delete(DELETE_SLO);
      history.replace({
        pathname,
        search: qParams.toString()
      });
    }
  }, [deleteSlo, history, pathname, search]);
  return {
    instanceId: !!instanceId && instanceId !== _sloSchema.ALL_VALUE ? instanceId : undefined,
    remoteName,
    isDeletingSlo: deleteSlo === 'true',
    removeDeleteQueryParam
  };
}