"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloDetailsAlerts = SloDetailsAlerts;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _sloSchema = require("@kbn/slo-schema");
var _common = require("@kbn/observability-shared-plugin/common");
var _kibana_react = require("../../../utils/kibana_react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloDetailsAlerts({
  slo
}) {
  var _slo$instanceId;
  const {
    triggersActionsUi: {
      alertsTableConfigurationRegistry,
      getAlertsStateTable: AlertsStateTable
    }
  } = (0, _kibana_react.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(AlertsStateTable, {
    alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
    configurationId: _ruleDataUtils.AlertConsumers.OBSERVABILITY,
    id: _common.SLO_ALERTS_TABLE_ID,
    "data-test-subj": "alertTable",
    featureIds: [_ruleDataUtils.AlertConsumers.SLO, _ruleDataUtils.AlertConsumers.OBSERVABILITY],
    query: {
      bool: {
        filter: [{
          term: {
            'slo.id': slo.id
          }
        }, {
          term: {
            'slo.instanceId': (_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE
          }
        }]
      }
    },
    showAlertStatusWithFlapping: true,
    pageSize: 100
  }))));
}