"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = Overview;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _display_query = require("./display_query");
var _kibana_react = require("../../../../utils/kibana_react");
var _labels = require("../../../../utils/slo/labels");
var _apm_indicator_overview = require("./apm_indicator_overview");
var _synthetics_indicator_overview = require("./synthetics_indicator_overview");
var _overview_item = require("./overview_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Overview({
  slo
}) {
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const {
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  const percentFormat = uiSettings.get('format:percent:defaultPattern');
  const hasNoData = slo.summary.status === 'NO_DATA';
  let IndicatorOverview = null;
  switch (slo.indicator.type) {
    case 'sli.apm.transactionDuration':
    case 'sli.apm.transactionErrorRate':
      IndicatorOverview = /*#__PURE__*/_react.default.createElement(_apm_indicator_overview.ApmIndicatorOverview, {
        slo: slo
      });
      break;
    case 'sli.synthetics.availability':
      IndicatorOverview = /*#__PURE__*/_react.default.createElement(_synthetics_indicator_overview.SyntheticsIndicatorOverview, {
        slo: slo
      });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    color: "transparent",
    "data-test-subj": "overview"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: isMobile ? 2 : 4,
    gutterSize: "l",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.observedValueTitle', {
      defaultMessage: 'Observed value'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _i18n.i18n.translate('xpack.slo.sloDetails.overview.observedValueSubtitle', {
      defaultMessage: '{value} (objective is {objective})',
      values: {
        value: hasNoData ? '-' : (0, _numeral.default)(slo.summary.sliValue).format(percentFormat),
        objective: (0, _numeral.default)(slo.objective.target).format(percentFormat)
      }
    }))
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.indicatorTypeTitle', {
      defaultMessage: 'Indicator type'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, (0, _labels.toIndicatorTypeLabel)(slo.indicator.type))
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.timeWindowTitle', {
      defaultMessage: 'Time window'
    }),
    subtitle: toTimeWindowLabel(slo.timeWindow)
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.budgetingMethodTitle', {
      defaultMessage: 'Budgeting method'
    }),
    subtitle: _sloSchema.occurrencesBudgetingMethodSchema.is(slo.budgetingMethod) ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _labels.BUDGETING_METHOD_OCCURRENCES) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, _labels.BUDGETING_METHOD_TIMESLICES, " (", slo.indicator.type === 'sli.metric.timeslice' ? _i18n.i18n.translate('xpack.slo.sloDetails.overview.timeslicesBudgetingMethodDetailsForTimesliceMetric', {
      defaultMessage: '{duration} slices',
      values: {
        duration: (0, _labels.toDurationLabel)(slo.objective.timesliceWindow)
      }
    }) : _i18n.i18n.translate('xpack.slo.sloDetails.overview.timeslicesBudgetingMethodDetails', {
      defaultMessage: '{duration} slices, {target} target',
      values: {
        duration: (0, _labels.toDurationLabel)(slo.objective.timesliceWindow),
        target: (0, _numeral.default)(slo.objective.timesliceTarget).format(percentFormat)
      }
    }), ")")
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.descriptionTitle', {
      defaultMessage: 'Description'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, !!slo.description ? slo.description : '-')
  }), /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.tagsTitle', {
      defaultMessage: 'Tags'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_public.TagsList, {
      tags: slo.tags
    })
  }), IndicatorOverview, 'index' in slo.indicator.params && /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.indexTitle', {
      defaultMessage: 'Index pattern'
    }),
    subtitle: slo.indicator.params.index
  }), 'filter' in slo.indicator.params && /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.overallQueryTitle', {
      defaultMessage: 'Overall query'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_display_query.DisplayQuery, {
      query: slo.indicator.params.filter,
      index: slo.indicator.params.index
    })
  }), 'good' in slo.indicator.params && _sloSchema.querySchema.is(slo.indicator.params.good) && /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.goodQueryTitle', {
      defaultMessage: 'Good query'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_display_query.DisplayQuery, {
      query: slo.indicator.params.good,
      index: slo.indicator.params.index
    })
  }), 'total' in slo.indicator.params && _sloSchema.querySchema.is(slo.indicator.params.total) && /*#__PURE__*/_react.default.createElement(_overview_item.OverviewItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.totalQueryTitle', {
      defaultMessage: 'Total query'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_display_query.DisplayQuery, {
      query: slo.indicator.params.total,
      index: slo.indicator.params.index
    })
  })));
}
function toTimeWindowLabel(timeWindow) {
  if (_sloSchema.rollingTimeWindowTypeSchema.is(timeWindow.type)) {
    return _i18n.i18n.translate('xpack.slo.sloDetails.overview.rollingTimeWindow', {
      defaultMessage: '{duration} rolling',
      values: {
        duration: (0, _labels.toDurationLabel)(timeWindow.duration)
      }
    });
  }
  return _i18n.i18n.translate('xpack.slo.sloDetails.overview.calendarAlignedTimeWindow', {
    defaultMessage: '{duration} calendar aligned',
    values: {
      duration: (0, _labels.toDurationAdverbLabel)(timeWindow.duration)
    }
  });
}