"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderControl = HeaderControl;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireWildcard(require("react"));
var _paths = require("../../../../common/locators/paths");
var _slo_delete_confirmation_modal = require("../../../components/slo/delete_confirmation_modal/slo_delete_confirmation_modal");
var _use_capabilities = require("../../../hooks/use_capabilities");
var _use_clone_slo = require("../../../hooks/use_clone_slo");
var _use_delete_slo = require("../../../hooks/use_delete_slo");
var _use_fetch_rules_for_slo = require("../../../hooks/use_fetch_rules_for_slo");
var _kibana_react = require("../../../utils/kibana_react");
var _convert_sli_apm_params_to_apm_app_deeplink_url = require("../../../utils/slo/convert_sli_apm_params_to_apm_app_deeplink_url");
var _indicator = require("../../../utils/slo/indicator");
var _edit_burn_rate_rule_flyout = require("../../slos/components/common/edit_burn_rate_rule_flyout");
var _use_get_query_params = require("../hooks/use_get_query_params");
var _use_slo_actions = require("../hooks/use_slo_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeaderControl({
  isLoading,
  slo
}) {
  var _rulesBySlo$slo$id, _slo$remote;
  const {
    application: {
      navigateToUrl,
      capabilities
    },
    http: {
      basePath
    },
    triggersActionsUi: {
      getAddRuleFlyout: AddRuleFlyout
    }
  } = (0, _kibana_react.useKibana)().services;
  const hasApmReadCapabilities = capabilities.apm.show;
  const {
    hasWriteCapabilities
  } = (0, _use_capabilities.useCapabilities)();
  const {
    isDeletingSlo,
    removeDeleteQueryParam
  } = (0, _use_get_query_params.useGetQueryParams)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [isRuleFlyoutVisible, setRuleFlyoutVisibility] = (0, _react.useState)(false);
  const [isEditRuleFlyoutOpen, setIsEditRuleFlyoutOpen] = (0, _react.useState)(false);
  const [isDeleteConfirmationModalOpen, setDeleteConfirmationModalOpen] = (0, _react.useState)(false);
  const {
    mutate: deleteSlo
  } = (0, _use_delete_slo.useDeleteSlo)();
  const {
    data: rulesBySlo,
    refetchRules
  } = (0, _use_fetch_rules_for_slo.useFetchRulesForSlo)({
    sloIds: slo ? [slo.id] : undefined
  });
  const rules = slo ? (_rulesBySlo$slo$id = rulesBySlo === null || rulesBySlo === void 0 ? void 0 : rulesBySlo[slo === null || slo === void 0 ? void 0 : slo.id]) !== null && _rulesBySlo$slo$id !== void 0 ? _rulesBySlo$slo$id : [] : [];
  const handleActionsClick = () => setIsPopoverOpen(value => !value);
  const closePopover = () => setIsPopoverOpen(false);
  (0, _react.useEffect)(() => {
    if (isDeletingSlo) {
      setDeleteConfirmationModalOpen(true);
    }
  }, [isDeletingSlo]);
  const onCloseRuleFlyout = () => {
    setRuleFlyoutVisibility(false);
  };
  const handleOpenRuleFlyout = () => {
    closePopover();
    setRuleFlyoutVisibility(true);
  };
  const {
    handleNavigateToRules,
    sloEditUrl,
    remoteDeleteUrl
  } = (0, _use_slo_actions.useSloActions)({
    slo,
    rules,
    setIsEditRuleFlyoutOpen,
    setIsActionsPopoverOpen: setIsPopoverOpen
  });
  const handleNavigateToApm = () => {
    if (!slo) {
      return undefined;
    }
    const url = (0, _convert_sli_apm_params_to_apm_app_deeplink_url.convertSliApmParamsToApmAppDeeplinkUrl)(slo);
    if (url) {
      navigateToUrl(basePath.prepend(url));
    }
  };
  const navigateToClone = (0, _use_clone_slo.useCloneSlo)();
  const handleClone = async () => {
    if (slo) {
      setIsPopoverOpen(false);
      navigateToClone(slo);
    }
  };
  const handleDelete = () => {
    if (!!remoteDeleteUrl) {
      window.open(remoteDeleteUrl, '_blank');
    } else {
      setDeleteConfirmationModalOpen(true);
      setIsPopoverOpen(false);
    }
  };
  const handleDeleteCancel = () => {
    removeDeleteQueryParam();
    setDeleteConfirmationModalOpen(false);
  };
  const handleDeleteConfirm = async () => {
    if (slo) {
      deleteSlo({
        id: slo.id,
        name: slo.name
      });
      navigate(basePath.prepend(_paths.paths.slos));
    }
  };
  const navigate = (0, _react.useCallback)(url => setTimeout(() => navigateToUrl(url)), [navigateToUrl]);
  const isRemote = !!(slo !== null && slo !== void 0 && slo.remote);
  const hasUndefinedRemoteKibanaUrl = !!(slo !== null && slo !== void 0 && slo.remote) && (slo === null || slo === void 0 ? void 0 : (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.kibanaUrl) === '';
  const showRemoteLinkIcon = isRemote ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout",
    size: "s",
    css: {
      marginLeft: '10px'
    }
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "sloDetailsHeaderControlPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "o11yHeaderControlActionsButton",
      fill: true,
      iconSide: "right",
      iconType: "arrowDown",
      iconSize: "s",
      onClick: handleActionsClick,
      isLoading: isLoading,
      disabled: isLoading
    }, _i18n.i18n.translate('xpack.slo.sloDetails.headerControl.actions', {
      defaultMessage: 'Actions'
    })),
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "m",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "edit",
      disabled: !hasWriteCapabilities || hasUndefinedRemoteKibanaUrl,
      icon: "pencil",
      href: sloEditUrl,
      target: isRemote ? '_blank' : undefined,
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : '',
      "data-test-subj": "sloDetailsHeaderControlPopoverEdit"
    }, _i18n.i18n.translate('xpack.slo.sloDetails.headerControl.edit', {
      defaultMessage: 'Edit'
    }), showRemoteLinkIcon), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "createBurnRateRule",
      disabled: !hasWriteCapabilities || isRemote,
      icon: "bell",
      onClick: handleOpenRuleFlyout,
      "data-test-subj": "sloDetailsHeaderControlPopoverCreateRule",
      toolTipContent: isRemote ? NOT_AVAILABLE_FOR_REMOTE : ''
    }, _i18n.i18n.translate('xpack.slo.sloDetails.headerControl.createBurnRateRule', {
      defaultMessage: 'Create new alert rule'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "manageRules",
      disabled: !hasWriteCapabilities || hasUndefinedRemoteKibanaUrl,
      icon: "gear",
      onClick: handleNavigateToRules,
      "data-test-subj": "sloDetailsHeaderControlPopoverManageRules",
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : ''
    }, _i18n.i18n.translate('xpack.slo.sloDetails.headerControl.manageRules', {
      defaultMessage: 'Manage burn rate {count, plural, one {rule} other {rules}}',
      values: {
        count: rules.length
      }
    }), showRemoteLinkIcon)].concat(!!slo && (0, _indicator.isApmIndicatorType)(slo.indicator) ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "exploreInApm",
      icon: "bullseye",
      disabled: !hasApmReadCapabilities || isRemote,
      onClick: handleNavigateToApm,
      "data-test-subj": "sloDetailsHeaderControlPopoverExploreInApm",
      toolTipContent: isRemote ? NOT_AVAILABLE_FOR_REMOTE : ''
    }, _i18n.i18n.translate('xpack.slo.sloDetails.headerControl.exploreInApm', {
      defaultMessage: 'Service details'
    })) : []).concat( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "clone",
      disabled: !hasWriteCapabilities || hasUndefinedRemoteKibanaUrl,
      icon: "copy",
      onClick: handleClone,
      "data-test-subj": "sloDetailsHeaderControlPopoverClone",
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : ''
    }, _i18n.i18n.translate('xpack.slo.slo.item.actions.clone', {
      defaultMessage: 'Clone'
    }), showRemoteLinkIcon), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "delete",
      icon: "trash",
      disabled: !hasWriteCapabilities || hasUndefinedRemoteKibanaUrl,
      onClick: handleDelete,
      "data-test-subj": "sloDetailsHeaderControlPopoverDelete",
      toolTipContent: hasUndefinedRemoteKibanaUrl ? NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL : ''
    }, _i18n.i18n.translate('xpack.slo.slo.item.actions.delete', {
      defaultMessage: 'Delete'
    }), showRemoteLinkIcon))
  })), /*#__PURE__*/_react.default.createElement(_edit_burn_rate_rule_flyout.EditBurnRateRuleFlyout, {
    rule: rules === null || rules === void 0 ? void 0 : rules[0],
    isEditRuleFlyoutOpen: isEditRuleFlyoutOpen,
    setIsEditRuleFlyoutOpen: setIsEditRuleFlyoutOpen,
    refetchRules: refetchRules
  }), slo && isRuleFlyoutVisible ? /*#__PURE__*/_react.default.createElement(AddRuleFlyout, {
    consumer: _common.sloFeatureId,
    ruleTypeId: _ruleDataUtils.SLO_BURN_RATE_RULE_TYPE_ID,
    canChangeTrigger: false,
    onClose: onCloseRuleFlyout,
    initialValues: {
      name: `${slo.name} burn rate`,
      params: {
        sloId: slo.id
      }
    },
    useRuleProducer: true
  }) : null, slo && isDeleteConfirmationModalOpen ? /*#__PURE__*/_react.default.createElement(_slo_delete_confirmation_modal.SloDeleteConfirmationModal, {
    slo: slo,
    onCancel: handleDeleteCancel,
    onConfirm: handleDeleteConfirm
  }) : null);
}
const NOT_AVAILABLE_FOR_REMOTE = _i18n.i18n.translate('xpack.slo.item.actions.notAvailable', {
  defaultMessage: 'This action is not available for remote SLOs'
});
const NOT_AVAILABLE_FOR_UNDEFINED_REMOTE_KIBANA_URL = _i18n.i18n.translate('xpack.slo.item.actions.remoteKibanaUrlUndefined', {
  defaultMessage: 'This action is not available for remote SLOs with undefined kibanaUrl'
});