"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventsChartPanel = EventsChartPanel;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _public = require("@kbn/charts-plugin/public");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_get_preview_data = require("../../../hooks/use_get_preview_data");
var _kibana_react = require("../../../utils/kibana_react");
var _constants = require("../../slo_edit/constants");
var _good_bad_events_chart = require("../../slos/components/common/good_bad_events_chart");
var _get_discover_link = require("../../../utils/slo/get_discover_link");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EventsChartPanel({
  slo,
  range
}) {
  var _slo$remote;
  const {
    charts,
    uiSettings,
    discover
  } = (0, _kibana_react.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const baseTheme = charts.theme.useChartsBaseTheme();
  const chartRef = (0, _react.useRef)(null);
  const handleCursorUpdate = (0, _public.useActiveCursor)(charts.activeCursor, chartRef, {
    isDateHistogram: true
  });
  const {
    isLoading,
    data
  } = (0, _use_get_preview_data.useGetPreviewData)({
    range,
    isValid: true,
    indicator: slo.indicator,
    groupings: slo.groupings,
    instanceId: slo.instanceId,
    remoteName: (_slo$remote = slo.remote) === null || _slo$remote === void 0 ? void 0 : _slo$remote.remoteName
  });
  const dateFormat = uiSettings.get('dateFormat');
  const title = slo.indicator.type !== 'sli.metric.timeslice' ? /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.slo.sloDetails.eventsChartPanel.title', {
    defaultMessage: 'Good vs bad events'
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.slo.sloDetails.eventsChartPanel.timesliceTitle', {
    defaultMessage: 'Timeslice metric'
  })));
  const threshold = slo.indicator.type === 'sli.metric.timeslice' ? slo.indicator.params.metric.threshold : undefined;
  const yAxisNumberFormat = slo.indicator.type === 'sli.metric.timeslice' ? '0,0[.00]' : '0,0';
  const values = (data || []).map(row => {
    if (slo.indicator.type === 'sli.metric.timeslice') {
      return row.sliValue;
    } else {
      var _row$events;
      return (row === null || row === void 0 ? void 0 : (_row$events = row.events) === null || _row$events === void 0 ? void 0 : _row$events.total) || 0;
    }
  });
  const maxValue = (0, _lodash.max)(values);
  const minValue = (0, _lodash.min)(values);
  const domain = {
    fit: true,
    min: threshold != null && minValue != null && threshold < minValue ? threshold : minValue || NaN,
    max: threshold != null && maxValue != null && threshold > maxValue ? threshold : maxValue || NaN
  };
  const annotation = slo.indicator.type === 'sli.metric.timeslice' && threshold ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "thresholdAnnotation",
    domainType: _charts.AnnotationDomainType.YDomain,
    dataValues: [{
      dataValue: threshold
    }],
    style: {
      line: {
        strokeWidth: 2,
        stroke: euiTheme.colors.warning || '#000',
        opacity: 1
      }
    },
    marker: /*#__PURE__*/_react.default.createElement("span", null, threshold),
    markerPosition: "right"
  }), /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    dataValues: [{
      coordinates: ['GT', 'GTE'].includes(slo.indicator.params.metric.comparator) ? {
        y0: threshold,
        y1: maxValue
      } : {
        y0: minValue,
        y1: threshold
      },
      details: `${_constants.COMPARATOR_MAPPING[slo.indicator.params.metric.comparator]} ${threshold}`
    }],
    id: "thresholdShade",
    style: {
      fill: euiTheme.colors.warning || '#000',
      opacity: 0.1
    }
  })) : null;
  const showViewEventsLink = !['sli.apm.transactionErrorRate', 'sli.apm.transactionDuration'].includes(slo.indicator.type);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "transparent",
    hasBorder: true,
    "data-test-subj": "eventsChartPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, " ", title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.slo.sloDetails.eventsChartPanel.duration', {
    defaultMessage: 'Last 24h'
  })))), showViewEventsLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "text",
    href: (0, _get_discover_link.getDiscoverLink)(discover, slo, {
      from: 'now-24h',
      to: 'now',
      mode: 'relative'
    }),
    "data-test-subj": "sloDetailDiscoverLink"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight",
    style: {
      marginRight: '4px'
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloDetails.viewEventsLink",
    defaultMessage: "View events"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, slo.indicator.type !== 'sli.metric.timeslice' ? /*#__PURE__*/_react.default.createElement(_good_bad_events_chart.GoodBadEventsChart, {
    isLoading: isLoading,
    data: data || [],
    annotation: annotation,
    slo: slo
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "m",
    mono: true,
    "data-test-subj": "sliEventsChartLoading"
  }), !isLoading && /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 150,
      width: '100%'
    },
    ref: chartRef
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.VerticalCursor
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    showLegend: slo.indicator.type !== 'sli.metric.timeslice',
    showLegendExtra: false,
    legendPosition: _charts.Position.Left,
    noResults: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visualizeApp",
      size: "l",
      color: "subdued",
      title: _i18n.i18n.translate('xpack.slo.eventsChartPanel.euiIcon.noResultsLabel', {
        defaultMessage: 'no results'
      })
    }),
    onPointerUpdate: handleCursorUpdate,
    externalPointerEvents: {
      tooltip: {
        visible: true
      }
    },
    pointerUpdateDebounce: 0,
    pointerUpdateTrigger: 'x',
    locale: _i18n.i18n.getLocale()
  }), annotation, /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: d => (0, _moment.default)(d).format(dateFormat)
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left",
    position: _charts.Position.Left,
    tickFormat: d => (0, _numeral.default)(d).format(yAxisNumberFormat),
    domain: domain
  }), /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: "Metric",
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "date",
    yAccessors: ['value'],
    data: (data !== null && data !== void 0 ? data : []).map(datum => ({
      date: new Date(datum.date).getTime(),
      value: datum.sliValue
    }))
  }))))));
}