"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorBudgetHeader = ErrorBudgetHeader;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _kibana_react = require("../../../utils/kibana_react");
var _labels = require("../../../utils/slo/labels");
var _error_budget_actions = require("./error_budget_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ErrorBudgetHeader({
  slo,
  showTitle = true,
  isMouseOver,
  setDashboardAttachmentReady
}) {
  const {
    executionContext
  } = (0, _kibana_react.useKibana)().services;
  const executionContextName = executionContext.get().name;
  const isDashboardContext = executionContextName === 'dashboards';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, showTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "errorBudgetPanelTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.slo.sloDetails.errorBudgetChartPanel.title', {
    defaultMessage: 'Error budget burn down'
  })))), !isDashboardContext && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    wrap: true
  }, isMouseOver && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_error_budget_actions.ErrorBudgetActions, {
    setDashboardAttachmentReady: setDashboardAttachmentReady
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _sloSchema.rollingTimeWindowTypeSchema.is(slo.timeWindow.type) ? _i18n.i18n.translate('xpack.slo.sloDetails.errorBudgetChartPanel.duration', {
    defaultMessage: 'Last {duration}',
    values: {
      duration: (0, _labels.toDurationLabel)(slo.timeWindow.duration)
    }
  }) : (0, _labels.toDurationAdverbLabel)(slo.timeWindow.duration))));
}