"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_plugin_context = require("../hooks/use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PageNotFound() {
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "pageNotFound"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "iInCircle",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.slo.notFoundPage.title",
      defaultMessage: "Page Not Found"
    }),
    "data-test-subj": 'observabilityPageNotFoundBanner'
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": 'observabilityPageNotFoundBannerText'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.notFoundPage.bannerText",
    defaultMessage: "The Observability application doesn't recognize this route"
  }))));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = PageNotFound;
module.exports = exports.default;