"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _paths = require("../../common/locators/paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SloEditLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _common.sloEditLocatorID);
    (0, _defineProperty2.default)(this, "getLocation", async slo => {
      return {
        app: 'slo',
        path: (0, _public.setStateToKbnUrl)('_a', {
          ...slo
        }, {
          useHash: false,
          storeInHashQuery: false
        }, slo.id ? `/edit/${encodeURIComponent(String(slo.id))}` : `${_paths.SLO_CREATE_PATH}`),
        state: {}
      };
    });
  }
}
exports.SloEditLocatorDefinition = SloEditLocatorDefinition;