"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSLOsWithBurnRateRules = useFetchSLOsWithBurnRateRules;
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/alerting-plugin/common");
var _kibana_react = require("../utils/kibana_react");
var _query_key_factory = require("./query_key_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchRules({
  search,
  http,
  signal
}) {
  const filter = 'alert.attributes.alertTypeId:slo.rules.burnRate';
  const query = {
    search,
    filter,
    fields: ['id', 'params.windows', 'name'],
    per_page: 1000
  };
  const response = await http.get(`${_common.BASE_ALERTING_API_PATH}/rules/_find`, {
    query,
    signal
  });
  return response.data;
}
function useFetchSLOsWithBurnRateRules({
  search = ''
}) {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.burnRateRules(search),
    queryFn: async ({
      signal
    }) => {
      try {
        return fetchRules({
          search,
          http,
          signal
        });
      } catch (error) {
        // ignore error for retrieving slos
      }
    },
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  return {
    data,
    isLoading,
    isInitialLoading,
    isRefetching,
    isSuccess,
    isError,
    refetch
  };
}