"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSloInstances = useFetchSloInstances;
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../utils/kibana_react");
var _query_key_factory = require("./query_key_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSloInstances({
  sloId
}) {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.detail(sloId),
    queryFn: async ({
      signal
    }) => {
      try {
        const response = await http.get(`/internal/observability/slos/${sloId}/_instances`, {
          query: {},
          signal
        });
        return response;
      } catch (error) {
        // ignore error for retrieving slos
      }
    },
    keepPreviousData: true,
    enabled: Boolean(sloId),
    refetchOnWindowFocus: false
  });
  return {
    data,
    isLoading,
    isInitialLoading,
    isRefetching,
    isSuccess,
    isError
  };
}