"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteSlo = useDeleteSlo;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../utils/kibana_react");
var _query_key_factory = require("./query_key_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDeleteSlo() {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)(['deleteSlo'], ({
    id
  }) => {
    try {
      return http.delete(`/api/observability/slos/${id}`);
    } catch (error) {
      return Promise.reject(`Something went wrong: ${String(error)}`);
    }
  }, {
    onError: (error, {
      name
    }, context) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.slo.slo.delete.errorNotification', {
          defaultMessage: 'Failed to delete {name}',
          values: {
            name
          }
        })
      });
    },
    onSuccess: (_data, {
      name
    }) => {
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.lists(),
        exact: false
      });
      toasts.addSuccess(_i18n.i18n.translate('xpack.slo.slo.delete.successNotification', {
        defaultMessage: 'Deleted {name}',
        values: {
          name
        }
      }));
    }
  });
}