"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCloneSlo = useCloneSlo;
var _rison = require("@kbn/rison");
var _react = require("react");
var _paths = require("../../common/locators/paths");
var _kibana_react = require("../utils/kibana_react");
var _remote_slo_urls = require("../utils/slo/remote_slo_urls");
var _use_space = require("./use_space");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCloneSlo() {
  const {
    http: {
      basePath
    },
    application: {
      navigateToUrl
    }
  } = (0, _kibana_react.useKibana)().services;
  const spaceId = (0, _use_space.useSpace)();
  return (0, _react.useCallback)(slo => {
    if (slo.remote) {
      window.open((0, _remote_slo_urls.createRemoteSloCloneUrl)(slo, spaceId), '_blank');
    } else {
      const clonePath = _paths.paths.sloCreateWithEncodedForm((0, _rison.encode)({
        ...slo,
        name: `[Copy] ${slo.name}`,
        id: undefined
      }));
      navigateToUrl(basePath.prepend(clonePath));
    }
  }, [navigateToUrl, basePath, spaceId]);
}