"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLO_ERROR_BUDGET_EMBEDDABLE = exports.SLOErrorBudgetEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@tanstack/react-query");
var _rxjs = require("rxjs");
var _history = require("history");
var _slo_error_budget_burn_down = require("./slo_error_budget_burn_down");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLO_ERROR_BUDGET_EMBEDDABLE = exports.SLO_ERROR_BUDGET_EMBEDDABLE = 'SLO_ERROR_BUDGET_EMBEDDABLE';
class SLOErrorBudgetEmbeddable extends _public.Embeddable {
  constructor(deps, initialInput, parent) {
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "type", SLO_ERROR_BUDGET_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "reloadSubject", void 0);
    this.deps = deps;
    this.reloadSubject = new _rxjs.Subject();
    this.setTitle(this.input.title || _i18n.i18n.translate('xpack.slo.sloErrorBudgetEmbeddable.displayTitle', {
      defaultMessage: 'SLO Error Budget burn down'
    }));
  }
  setTitle(title) {
    this.updateInput({
      title
    });
  }
  onRenderComplete() {
    this.renderComplete.dispatchComplete();
  }
  render(node) {
    super.render(node);
    this.node = node;
    // required for the export feature to work
    this.node.setAttribute('data-shared-item', '');
    const {
      sloId,
      sloInstanceId
    } = this.getInput();
    const queryClient = new _reactQuery.QueryClient();
    const I18nContext = this.deps.i18n.Context;
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
      history: (0, _history.createBrowserHistory)()
    }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
      services: this.deps
    }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
      client: queryClient
    }, /*#__PURE__*/_react.default.createElement(_slo_error_budget_burn_down.SloErrorBudget, {
      sloId: sloId,
      sloInstanceId: sloInstanceId
    }))))), node);
  }
  reload() {
    this.reloadSubject.next(true);
  }
  destroy() {
    super.destroy();
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
  }
}
exports.SLOErrorBudgetEmbeddable = SLOErrorBudgetEmbeddable;