"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloAlertsWrapper = SloAlertsWrapper;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("@kbn/observability-plugin/common");
var _slo_included_count = require("./components/slo_included_count");
var _slo_alerts_summary = require("./components/slo_alerts_summary");
var _slo_alerts_table = require("./components/slo_alerts_table");
var _edit_slo_alerts_panel = require("../../../ui_actions/edit_slo_alerts_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloAlertsWrapper({
  embeddable,
  slos: initialSlos,
  deps,
  timeRange: initialTimeRange,
  onRenderComplete,
  reloadSubject,
  showAllGroupByInstances: initialShowAllGroupByInstances
}) {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = deps;
  const [timeRange, setTimeRange] = (0, _react.useState)(initialTimeRange);
  const [slos, setSlos] = (0, _react.useState)(initialSlos);
  const [showAllGroupByInstances, setShowAllGroupByInstances] = (0, _react.useState)(initialShowAllGroupByInstances);
  const [lastRefreshTime, setLastRefreshTime] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    const subs = reloadSubject === null || reloadSubject === void 0 ? void 0 : reloadSubject.subscribe(input => {
      if (input) {
        const {
          timeRange: nTimeRange,
          slos: nSlos
        } = input;
        setSlos(nSlos);
        if (nTimeRange && (nTimeRange.from !== timeRange.from || nTimeRange.to !== timeRange.to)) {
          setTimeRange(nTimeRange);
        }
        setShowAllGroupByInstances(input.showAllGroupByInstances);
      }
      setLastRefreshTime(Date.now());
    });
    return () => {
      subs === null || subs === void 0 ? void 0 : subs.unsubscribe();
    };
  }, [reloadSubject, timeRange.from, timeRange.to]);
  (0, _react.useEffect)(() => {
    setTimeRange(initialTimeRange);
  }, [initialTimeRange]);
  const [isSummaryLoaded, setIsSummaryLoaded] = (0, _react.useState)(false);
  const [isTableLoaded, setIsTableLoaded] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (isSummaryLoaded && isTableLoaded && onRenderComplete) {
      onRenderComplete();
    }
  }, [isSummaryLoaded, isTableLoaded, onRenderComplete]);
  const handleGoToAlertsClick = () => {
    let kuery = '';
    slos.map((slo, index) => {
      const shouldAddOr = index < slos.length - 1;
      kuery += `(slo.id:"${slo.id}" and slo.instanceId:"${slo.instanceId}")`;
      if (shouldAddOr) {
        kuery += ' or ';
      }
    });
    navigateToUrl(`${basePath.prepend(_common.observabilityPaths.alerts)}?_a=(kuery:'${kuery}',rangeFrom:${timeRange.from},rangeTo:${timeRange.to})`);
  };
  return /*#__PURE__*/_react.default.createElement(Wrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    wrap: true,
    css: `
          margin: 0 35px;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      const trigger = deps.uiActions.getTrigger(_public.CONTEXT_MENU_TRIGGER);
      deps.uiActions.getAction(_edit_slo_alerts_panel.EDIT_SLO_ALERTS_ACTION).execute({
        trigger,
        embeddable
      });
    },
    "data-test-subj": "o11ySloAlertsWrapperSlOsIncludedLink"
  }, showAllGroupByInstances ? /*#__PURE__*/_react.default.createElement(_slo_included_count.SloIncludedCount, {
    slos: slos
  }) : _i18n.i18n.translate('xpack.slo.sloAlertsWrapper.sLOsIncludedFlexItemLabel', {
    defaultMessage: '{numOfSlos, number} {numOfSlos, plural, one {SLO} other {SLOs}} included',
    values: {
      numOfSlos: slos.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "o11ySloAlertsWrapperGoToAlertsLink",
    onClick: handleGoToAlertsClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloAlertsWrapper.goToAlertsFlexItemLabel",
    defaultMessage: "Go to alerts"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    style: {
      margin: '10px'
    },
    responsive: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_slo_alerts_summary.SloAlertsSummary, {
    slos: slos,
    deps: deps,
    timeRange: timeRange,
    onLoaded: () => setIsSummaryLoaded(true),
    showAllGroupByInstances: showAllGroupByInstances
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_slo_alerts_table.SloAlertsTable, {
    slos: slos,
    deps: deps,
    timeRange: timeRange,
    onLoaded: () => setIsTableLoaded(true),
    lastReloadRequestTime: lastRefreshTime,
    showAllGroupByInstances: showAllGroupByInstances
  }))));
}
const Wrapper = _styledComponents.default.div`
  width: 100%;
`;