"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloAlertsEmbeddableFactoryDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _slo_embeddable_factory = require("../overview/slo_embeddable_factory");
var _slo_alerts_embeddable = require("./slo_alerts_embeddable");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class SloAlertsEmbeddableFactoryDefinition {
  constructor(getStartServices, kibanaVersion) {
    (0, _defineProperty2.default)(this, "type", _slo_alerts_embeddable.SLO_ALERTS_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "grouping", _slo_embeddable_factory.COMMON_SLO_GROUPING);
    this.getStartServices = getStartServices;
    this.kibanaVersion = kibanaVersion;
  }
  async isEditable() {
    return true;
  }
  async getExplicitInput() {
    const [coreStart, pluginStart] = await this.getStartServices();
    try {
      const {
        resolveEmbeddableSloUserInput
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./handle_explicit_input')));
      return await resolveEmbeddableSloUserInput(coreStart, pluginStart);
    } catch (e) {
      return Promise.reject();
    }
  }
  async create(initialInput, parent) {
    try {
      const [coreStart, pluginsStart] = await this.getStartServices();
      const deps = {
        ...coreStart,
        ...pluginsStart
      };
      return new _slo_alerts_embeddable.SLOAlertsEmbeddable(deps, initialInput, this.kibanaVersion, parent);
    } catch (e) {
      return new _public.ErrorEmbeddable(e, initialInput, parent);
    }
  }
  getDescription() {
    return _i18n.i18n.translate('xpack.slo.sloAlertsEmbeddable.description', {
      defaultMessage: 'Get an overview of your SLO alerts'
    });
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.slo.sloAlertsEmbeddable.displayName', {
      defaultMessage: 'SLO Alerts'
    });
  }
  getIconType() {
    return 'alert';
  }
}
exports.SloAlertsEmbeddableFactoryDefinition = SloAlertsEmbeddableFactoryDefinition;