"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloAlertsTable = SloAlertsTable;
exports.useSloAlertsQuery = exports.getSloInstanceFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _sloSchema = require("@kbn/slo-schema");
var _constants = require("../../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_PER_PAGE = 10;
const ALERTS_TABLE_ID = 'xpack.observability.sloAlertsEmbeddable.alert.table';
const getSloInstanceFilter = (sloId, sloInstanceId, showAllGroupByInstances = false) => {
  return {
    bool: {
      must: [{
        term: {
          'slo.id': sloId
        }
      }, ...(sloInstanceId !== _sloSchema.ALL_VALUE && !showAllGroupByInstances ? [{
        term: {
          'slo.instanceId': sloInstanceId
        }
      }] : [])]
    }
  };
};
exports.getSloInstanceFilter = getSloInstanceFilter;
const useSloAlertsQuery = (slos, timeRange, showAllGroupByInstances) => {
  return (0, _react.useMemo)(() => {
    const query = {
      bool: {
        filter: [{
          range: {
            '@timestamp': {
              gte: timeRange.from
            }
          }
        }, {
          term: {
            'kibana.alert.rule.rule_type_id': 'slo.rules.burnRate'
          }
        }, {
          bool: {
            should: slos.map(slo => getSloInstanceFilter(slo.id, slo.instanceId, showAllGroupByInstances))
          }
        }]
      }
    };
    return query;
  }, [showAllGroupByInstances, slos, timeRange.from]);
};
exports.useSloAlertsQuery = useSloAlertsQuery;
function SloAlertsTable({
  slos,
  deps,
  timeRange,
  onLoaded,
  lastReloadRequestTime,
  showAllGroupByInstances
}) {
  const {
    triggersActionsUi: {
      alertsTableConfigurationRegistry,
      getAlertsStateTable: AlertsStateTable
    }
  } = deps;
  return /*#__PURE__*/_react.default.createElement(AlertsStateTable, {
    query: useSloAlertsQuery(slos, timeRange, showAllGroupByInstances),
    alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
    configurationId: _constants.SLO_ALERTS_TABLE_CONFIG_ID,
    featureIds: [_ruleDataUtils.AlertConsumers.SLO, _ruleDataUtils.AlertConsumers.OBSERVABILITY],
    hideLazyLoader: true,
    id: ALERTS_TABLE_ID,
    pageSize: ALERTS_PER_PAGE,
    showAlertStatusWithFlapping: true,
    onLoaded: () => {
      if (onLoaded) {
        onLoaded();
      }
    },
    lastReloadRequestTime: lastReloadRequestTime
  });
}