"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorRatePanel = ErrorRatePanel;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireDefault(require("react"));
var _kibana_react = require("../../../../../../utils/kibana_react");
var _error_rate_chart = require("../../../../error_rate_chart");
var _alert = require("../../utils/alert");
var _last_duration_i18n = require("../../utils/last_duration_i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDataTimeRange(timeRange, window) {
  const windowDurationInMs = window.longWindow.value * 60 * 60 * 1000;
  return {
    from: new Date(new Date(timeRange.gte).getTime() - windowDurationInMs),
    to: timeRange.lte ? new Date(timeRange.lte) : new Date()
  };
}
function getAlertTimeRange(timeRange) {
  return {
    from: new Date(timeRange.gte),
    to: timeRange.lte ? new Date(timeRange.lte) : new Date()
  };
}
function ErrorRatePanel({
  alert,
  slo,
  isLoading
}) {
  var _alert$fields$ALERT_R, _alert$fields$ALERT_R2;
  const {
    services: {
      http
    }
  } = (0, _kibana_react.useKibana)();
  const actionGroup = (0, _alert.getActionGroupFromReason)(alert.reason);
  const actionGroupWindow = ((_alert$fields$ALERT_R = (_alert$fields$ALERT_R2 = alert.fields[_ruleDataUtils.ALERT_RULE_PARAMETERS]) === null || _alert$fields$ALERT_R2 === void 0 ? void 0 : _alert$fields$ALERT_R2.windows) !== null && _alert$fields$ALERT_R !== void 0 ? _alert$fields$ALERT_R : []).find(window => window.actionGroup === actionGroup);

  // @ts-ignore
  const dataTimeRange = getDataTimeRange(alert.fields[_ruleDataUtils.ALERT_TIME_RANGE], actionGroupWindow);
  // @ts-ignore
  const alertTimeRange = getAlertTimeRange(alert.fields[_ruleDataUtils.ALERT_TIME_RANGE]);
  const burnRate = alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUE];
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      size: "m",
      mono: true,
      "data-test-subj": "loading"
    });
  }
  if (!slo) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "transparent",
    hasBorder: true,
    "data-test-subj": "burnRatePanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetailsAppSection.burnRate.title', {
    defaultMessage: '{sloName} burn rate',
    values: {
      sloName: slo.name
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "text",
    "data-test-subj": "o11yErrorRatePanelSloDetailsLink",
    href: http.basePath.prepend(alert.link)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight",
    style: {
      marginRight: '4px'
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.burnRateRule.alertDetailsAppSection.burnRate.sloDetailsLink",
    defaultMessage: "SLO details"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("span", null, (0, _last_duration_i18n.getLastDurationInUnit)(dataTimeRange))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "danger",
    hasShadow: false,
    paddingSize: "s",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "column",
    style: {
      minHeight: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "default",
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetailsAppSection.burnRate.thresholdBreachedTitle', {
    defaultMessage: 'Threshold breached'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    style: {
      marginLeft: '4px'
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: `${(0, _numeral.default)(burnRate).format('0.[00]')}x`,
    titleColor: "default",
    titleSize: "s",
    textAlign: "right",
    isLoading: isLoading,
    "data-test-subj": "burnRateStat",
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "default"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetailsAppSection.burnRate.tresholdSubtitle', {
      defaultMessage: 'Alert when > {threshold}x',
      values: {
        threshold: (0, _numeral.default)(actionGroupWindow.burnRateThreshold).format('0.[00]')
      }
    })))
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_error_rate_chart.ErrorRateChart, {
    slo: slo,
    dataTimeRange: dataTimeRange,
    alertTimeRange: alertTimeRange,
    threshold: actionGroupWindow.burnRateThreshold,
    showErrorRateAsLine: true
  })))));
}