"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomKqlPanels = CustomKqlPanels;
var _react = _interopRequireDefault(require("react"));
var _log_rate_analysis_panel = require("./log_rate_analysis_panel");
var _use_license = require("../../../../../../../hooks/use_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CustomKqlPanels({
  slo,
  alert,
  rule
}) {
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const hasLicenseForLogRateAnalysis = hasAtLeast('platinum');
  return hasLicenseForLogRateAnalysis ? /*#__PURE__*/_react.default.createElement(_log_rate_analysis_panel.LogRateAnalysisPanel, {
    slo: slo,
    alert: alert,
    rule: rule
  }) : null;
}