"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsHistoryPanel = AlertsHistoryPanel;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _observabilityAlertDetails = require("@kbn/observability-alert-details");
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _kibana_react = require("../../../../../../utils/kibana_react");
var _error_rate_chart = require("../../../../error_rate_chart");
var _alert = require("../../utils/alert");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertsHistoryPanel({
  rule,
  slo,
  alert,
  isLoading
}) {
  var _alert$fields$ALERT_R, _alert$fields$ALERT_R2;
  const {
    services: {
      http
    }
  } = (0, _kibana_react.useKibana)();
  const {
    isLoading: isAlertsHistoryLoading,
    data
  } = (0, _observabilityAlertDetails.useAlertsHistory)({
    featureIds: ['slo'],
    ruleId: rule.id,
    dateRange: {
      from: 'now-30d',
      to: 'now'
    },
    http,
    instanceId: alert.fields[_ruleDataUtils.ALERT_INSTANCE_ID]
  });
  const actionGroup = (0, _alert.getActionGroupFromReason)(alert.reason);
  const actionGroupWindow = ((_alert$fields$ALERT_R = (_alert$fields$ALERT_R2 = alert.fields[_ruleDataUtils.ALERT_RULE_PARAMETERS]) === null || _alert$fields$ALERT_R2 === void 0 ? void 0 : _alert$fields$ALERT_R2.windows) !== null && _alert$fields$ALERT_R !== void 0 ? _alert$fields$ALERT_R : []).find(window => window.actionGroup === actionGroup);
  const dataTimeRange = {
    from: (0, _moment.default)().subtract(30, 'day').toDate(),
    to: new Date()
  };
  function getAlertsLink() {
    const kuery = `kibana.alert.rule.uuid:"${rule.id}"`;
    return http.basePath.prepend(`/app/observability/alerts?_a=${_rison.default.encode({
      kuery
    })}`);
  }
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      size: "m",
      mono: true,
      "data-test-subj": "loading"
    });
  }
  if (!slo) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "transparent",
    hasBorder: true,
    "data-test-subj": "alertsHistoryPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetailsAppSection.alertsHistory.title', {
    defaultMessage: '{sloName} alerts history',
    values: {
      sloName: slo.name
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "text",
    href: getAlertsLink(),
    "data-test-subj": "alertsLink"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight",
    style: {
      marginRight: '4px'
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.burnRateRule.alertDetailsAppSection.alertsHistory.alertsLink",
    defaultMessage: "View alerts"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetailsAppSection.alertsHistory.subtitle', {
    defaultMessage: 'Last 30 days'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: isAlertsHistoryLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    }) : data.totalTriggeredAlerts ? data.totalTriggeredAlerts : '-',
    titleColor: "danger",
    titleSize: "m",
    textAlign: "left",
    isLoading: isLoading,
    "data-test-subj": "alertsTriggeredStats",
    reverse: true,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "default"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetailsAppSection.alertsHistory.triggeredAlertsStatsTitle', {
      defaultMessage: 'Alerts triggered'
    })))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: isAlertsHistoryLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    }) : data.avgTimeToRecoverUS ? (0, _public.convertTo)({
      unit: 'minutes',
      microseconds: data.avgTimeToRecoverUS,
      extended: true
    }).formatted : '-',
    titleColor: "default",
    titleSize: "m",
    textAlign: "left",
    isLoading: isLoading,
    "data-test-subj": "avgTimeToRecoverStat",
    reverse: true,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "default"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.slo.burnRateRule.alertDetailsAppSection.alertsHistory.avgTimeToRecoverStatsTitle', {
      defaultMessage: 'Avg time to recover'
    })))
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isAlertsHistoryLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : /*#__PURE__*/_react.default.createElement(_error_rate_chart.ErrorRateChart, {
    slo: slo,
    dataTimeRange: dataTimeRange,
    threshold: actionGroupWindow.burnRateThreshold,
    annotations: data.histogramTriggeredAlerts.filter(a => a.doc_count > 0).map(a => ({
      date: new Date(a.key_as_string),
      total: a.doc_count
    })),
    showErrorRateAsLine: true
  })))));
}