"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getListOfSloSummaryIndices = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getListOfSloSummaryIndices = (settings, clustersByName) => {
  const {
    useAllRemoteClusters,
    selectedRemoteClusters
  } = settings;
  if (!useAllRemoteClusters && selectedRemoteClusters.length === 0) {
    return _constants.SLO_SUMMARY_DESTINATION_INDEX_PATTERN;
  }
  const indices = [_constants.SLO_SUMMARY_DESTINATION_INDEX_PATTERN];
  clustersByName.forEach(({
    name,
    isConnected
  }) => {
    if (isConnected && (useAllRemoteClusters || selectedRemoteClusters.includes(name))) {
      indices.push(`${name}:${_constants.SLO_SUMMARY_DESTINATION_INDEX_PATTERN}`);
    }
  });
  return indices.join(',');
};
exports.getListOfSloSummaryIndices = getListOfSloSummaryIndices;