"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.paths = exports.SLO_SETTINGS_PATH = exports.SLO_EDIT_PATH = exports.SLO_DETAIL_PATH = exports.SLO_CREATE_PATH = exports.SLOS_WELCOME_PATH = exports.SLOS_PATH = exports.SLOS_OUTDATED_DEFINITIONS_PATH = exports.SLOS_BASE_PATH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SLOS_BASE_PATH = exports.SLOS_BASE_PATH = '/app/slos';
const SLOS_PATH = exports.SLOS_PATH = '/';
const SLOS_WELCOME_PATH = exports.SLOS_WELCOME_PATH = '/welcome';
const SLO_DETAIL_PATH = exports.SLO_DETAIL_PATH = '/:sloId';
const SLO_CREATE_PATH = exports.SLO_CREATE_PATH = '/create';
const SLO_EDIT_PATH = exports.SLO_EDIT_PATH = '/edit/:sloId';
const SLOS_OUTDATED_DEFINITIONS_PATH = exports.SLOS_OUTDATED_DEFINITIONS_PATH = '/outdated-definitions';
const SLO_SETTINGS_PATH = exports.SLO_SETTINGS_PATH = '/settings';
const paths = exports.paths = {
  slos: `${SLOS_BASE_PATH}${SLOS_PATH}`,
  slosSettings: `${SLOS_BASE_PATH}${SLO_SETTINGS_PATH}`,
  slosWelcome: `${SLOS_BASE_PATH}${SLOS_WELCOME_PATH}`,
  slosOutdatedDefinitions: `${SLOS_BASE_PATH}${SLOS_OUTDATED_DEFINITIONS_PATH}`,
  sloCreate: `${SLOS_BASE_PATH}${SLO_CREATE_PATH}`,
  sloCreateWithEncodedForm: encodedParams => `${SLOS_BASE_PATH}${SLO_CREATE_PATH}?_a=${encodedParams}`,
  sloEdit: sloId => `${SLOS_BASE_PATH}/edit/${encodeURIComponent(sloId)}`,
  sloEditWithEncodedForm: (sloId, encodedParams) => `${SLOS_BASE_PATH}/edit/${encodeURIComponent(sloId)}?_a=${encodedParams}`,
  sloDetails: (sloId, instanceId, remoteName) => {
    const qs = new URLSearchParams();
    if (!!instanceId) qs.append('instanceId', instanceId);
    if (!!remoteName) qs.append('remoteName', remoteName);
    return `${SLOS_BASE_PATH}/${encodeURIComponent(sloId)}?${qs.toString()}`;
  }
};