"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecoverablePrompt = exports.FatalPrompt = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _message_strings = require("./message_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CodePanel = props => {
  var _ref, _errorInfo$componentS, _error$stack;
  const {
    error,
    errorInfo,
    name: errorComponentName,
    onClose
  } = props;
  const simpleFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'simpleFlyoutTitle'
  });
  const errorName = errorComponentName && _message_strings.errorMessageStrings.fatal.callout.details.componentName(errorComponentName);
  const errorTrace = (_ref = (_errorInfo$componentS = errorInfo === null || errorInfo === void 0 ? void 0 : errorInfo.componentStack) !== null && _errorInfo$componentS !== void 0 ? _errorInfo$componentS : error.stack) !== null && _ref !== void 0 ? _ref : error.toString();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": simpleFlyoutTitleId,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _message_strings.errorMessageStrings.fatal.callout.details.title())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "data-test-subj": "errorBoundaryFatalDetailsErrorString"
  }, /*#__PURE__*/_react.default.createElement("p", null, ((_error$stack = error.stack) !== null && _error$stack !== void 0 ? _error$stack : error.toString()) + '\n\n'), /*#__PURE__*/_react.default.createElement("p", null, errorName, errorTrace))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left"
  }, _message_strings.errorMessageStrings.fatal.callout.details.closeButton())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: errorName + '\n\n' + errorTrace
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: copy,
    fill: true,
    iconType: "copyClipboard"
  }, _message_strings.errorMessageStrings.fatal.callout.details.copyToClipboardButton())))))));
};
const FatalPrompt = props => {
  const {
    onClickRefresh
  } = props;
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", {
      "data-test-subj": "errorBoundaryFatalHeader"
    }, _message_strings.errorMessageStrings.fatal.callout.title()),
    color: "danger",
    iconType: "error",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": "errorBoundaryFatalPromptBody"
    }, _message_strings.errorMessageStrings.fatal.callout.body()), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      iconType: "refresh",
      fill: true,
      onClick: onClickRefresh,
      "data-test-subj": "errorBoundaryFatalPromptReloadBtn"
    }, _message_strings.errorMessageStrings.fatal.callout.pageReloadButton())), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      color: "danger",
      onClick: () => setIsFlyoutVisible(true),
      "data-test-subj": "errorBoundaryFatalShowDetailsBtn"
    }, _message_strings.errorMessageStrings.fatal.callout.showDetailsButton()), isFlyoutVisible ? /*#__PURE__*/_react.default.createElement(CodePanel, (0, _extends2.default)({}, props, {
      onClose: () => setIsFlyoutVisible(false)
    })) : null))
  });
};
exports.FatalPrompt = FatalPrompt;
const RecoverablePrompt = props => {
  const {
    onClickRefresh
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", {
      "data-test-subj": "errorBoundaryRecoverableHeader"
    }, _message_strings.errorMessageStrings.recoverable.callout.title()),
    color: "warning",
    iconType: "warning",
    body: /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": "errorBoundaryRecoverablePromptBody"
    }, _message_strings.errorMessageStrings.recoverable.callout.body()),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "warning",
      iconType: "refresh",
      fill: true,
      onClick: onClickRefresh,
      "data-test-subj": "errorBoundaryRecoverablePromptReloadBtn"
    }, _message_strings.errorMessageStrings.recoverable.callout.pageReloadButton())
  });
};
exports.RecoverablePrompt = RecoverablePrompt;