"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaErrorBoundary = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _error_boundary_services = require("../services/error_boundary_services");
var _message_components = require("./message_components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ErrorBoundaryInternal extends _react.default.Component {
  constructor(props) {
    super(props);
    this.state = {
      error: null,
      errorInfo: null,
      componentName: null,
      isFatal: null
    };
  }
  componentDidCatch(error, errorInfo) {
    const {
      name,
      isFatal
    } = this.props.services.errorService.registerError(error, errorInfo);
    this.setState(() => {
      return {
        error,
        errorInfo,
        componentName: name,
        isFatal
      };
    });
  }
  render() {
    if (this.state.error != null) {
      const {
        error,
        errorInfo,
        componentName,
        isFatal
      } = this.state;
      if (isFatal) {
        return /*#__PURE__*/_react.default.createElement(_message_components.FatalPrompt, {
          error: error,
          errorInfo: errorInfo,
          name: componentName,
          onClickRefresh: this.props.services.onClickRefresh
        });
      } else {
        return /*#__PURE__*/_react.default.createElement(_message_components.RecoverablePrompt, {
          error: error,
          errorInfo: errorInfo,
          name: componentName,
          onClickRefresh: this.props.services.onClickRefresh
        });
      }
    }

    // not in error state
    return this.props.children;
  }
}

/**
 * Implementation of Kibana Error Boundary
 * @param {ErrorBoundaryProps} props - ErrorBoundaryProps
 * @public
 */
const KibanaErrorBoundary = props => {
  const services = (0, _error_boundary_services.useErrorBoundary)();
  return /*#__PURE__*/_react.default.createElement(ErrorBoundaryInternal, (0, _extends2.default)({}, props, {
    services: services
  }));
};
exports.KibanaErrorBoundary = KibanaErrorBoundary;