"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShareMenuManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _share_tabs = require("../components/share_tabs");
var _share_context_menu = require("../components/share_context_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ShareMenuManager {
  constructor() {
    (0, _defineProperty2.default)(this, "isOpen", false);
    (0, _defineProperty2.default)(this, "container", document.createElement('div'));
    (0, _defineProperty2.default)(this, "onClose", () => {
      _reactDom.default.unmountComponentAtNode(this.container);
      this.isOpen = false;
    });
  }
  start(core, urlService, shareRegistry, disableEmbed, newVersionEnabled, anonymousAccessServiceProvider) {
    return {
      /**
       * Collects share menu items from registered providers and mounts the share context menu under
       * the given `anchorElement`. If the context menu is already opened, a call to this method closes it.
       * @param options
       */
      toggleShareContextMenu: options => {
        const onClose = () => {
          var _options$onClose;
          this.onClose();
          (_options$onClose = options.onClose) === null || _options$onClose === void 0 ? void 0 : _options$onClose.call(options);
        };
        const menuItems = shareRegistry.getShareMenuItems({
          ...options,
          onClose
        });
        const anonymousAccess = anonymousAccessServiceProvider === null || anonymousAccessServiceProvider === void 0 ? void 0 : anonymousAccessServiceProvider();
        this.toggleShareContextMenu({
          ...options,
          allowEmbed: disableEmbed ? false : options.allowEmbed,
          onClose,
          menuItems,
          urlService,
          anonymousAccess,
          theme: core.theme,
          overlays: core.overlays,
          i18n: core.i18n,
          newVersionEnabled,
          toasts: core.notifications.toasts
        });
      }
    };
  }
  toggleShareContextMenu({
    anchorElement,
    allowEmbed,
    allowShortUrl,
    objectId,
    objectType,
    sharingData,
    menuItems,
    shareableUrl,
    shareableUrlForSavedObject,
    shareableUrlLocatorParams,
    embedUrlParamExtensions,
    theme,
    showPublicUrlSwitch,
    urlService,
    anonymousAccess,
    snapshotShareWarning,
    onClose,
    objectTypeTitle,
    disabledShareUrl,
    overlays,
    i18n,
    isDirty,
    newVersionEnabled,
    toasts
  }) {
    if (this.isOpen) {
      onClose();
      return;
    }
    this.isOpen = true;
    document.body.appendChild(this.container);
    if (!newVersionEnabled) {
      const element = /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
        theme: theme
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
        id: "sharePopover",
        button: anchorElement,
        isOpen: true,
        closePopover: onClose,
        panelPaddingSize: "none",
        anchorPosition: "downLeft"
      }, /*#__PURE__*/_react.default.createElement(_share_context_menu.ShareContextMenu, {
        allowEmbed: allowEmbed,
        allowShortUrl: allowShortUrl,
        objectId: objectId,
        objectType: objectType,
        objectTypeTitle: objectTypeTitle,
        shareMenuItems: menuItems,
        sharingData: sharingData,
        shareableUrl: shareableUrl,
        shareableUrlForSavedObject: shareableUrlForSavedObject,
        shareableUrlLocatorParams: shareableUrlLocatorParams,
        onClose: onClose,
        embedUrlParamExtensions: embedUrlParamExtensions,
        anonymousAccess: anonymousAccess,
        showPublicUrlSwitch: showPublicUrlSwitch,
        urlService: urlService,
        snapshotShareWarning: snapshotShareWarning,
        disabledShareUrl: disabledShareUrl
      }))));
      _reactDom.default.render(element, this.container);
    } else if (newVersionEnabled) {
      const openModal = () => {
        const session = overlays.openModal((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_share_tabs.ShareMenuV2, {
          shareContext: {
            allowEmbed,
            allowShortUrl,
            objectId,
            objectType,
            objectTypeTitle,
            sharingData,
            shareableUrl,
            shareableUrlForSavedObject,
            shareableUrlLocatorParams,
            embedUrlParamExtensions,
            anonymousAccess,
            showPublicUrlSwitch,
            urlService,
            snapshotShareWarning,
            disabledShareUrl,
            isDirty,
            isEmbedded: allowEmbed,
            shareMenuItems: menuItems,
            onClose: () => {
              onClose();
              session.close();
            },
            theme,
            i18n,
            toasts
          }
        }), {
          i18n,
          theme
        }), {
          'data-test-subj': 'share-modal'
        });
      };

      // @ts-ignore openModal() returns void
      anchorElement.onclick(openModal());
    }
  }
}
exports.ShareMenuManager = ShareMenuManager;