"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkContent = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _url = require("url");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LinkContent = ({
  objectType,
  objectId,
  isDirty,
  shareableUrl,
  shareableUrlForSavedObject,
  urlService,
  shareableUrlLocatorParams,
  allowShortUrl
}) => {
  var _ref;
  const [url, setUrl] = (0, _react.useState)('');
  const [urlParams] = (0, _react.useState)(undefined);
  const [isTextCopied, setTextCopied] = (0, _react.useState)(false);
  const [shortUrlCache, setShortUrlCache] = (0, _react.useState)(undefined);
  const isNotSaved = (0, _react.useCallback)(() => {
    return isDirty;
  }, [isDirty]);
  const getUrlParamExtensions = (0, _react.useCallback)(tempUrl => {
    if (!urlParams) return tempUrl;
    return Object.keys(urlParams).reduce((urlAccumulator, key) => {
      const urlParam = urlParams[key];
      return urlParam ? Object.keys(urlParam).reduce((queryAccumulator, queryParam) => {
        const isQueryParamEnabled = urlParam[queryParam];
        return isQueryParamEnabled ? queryAccumulator + `&${queryParam}=true` : queryAccumulator;
      }, urlAccumulator) : urlAccumulator;
    }, tempUrl);
  }, [urlParams]);
  const updateUrlParams = (0, _react.useCallback)(tempUrl => {
    tempUrl = urlParams ? getUrlParamExtensions(tempUrl) : tempUrl;
    setUrl(tempUrl);
    return tempUrl;
  }, [getUrlParamExtensions, urlParams]);
  const getSnapshotUrl = (0, _react.useCallback)(forSavedObject => {
    let tempUrl = '';
    if (forSavedObject && shareableUrlForSavedObject) {
      tempUrl = shareableUrlForSavedObject;
    }
    if (!tempUrl) {
      tempUrl = shareableUrl || window.location.href;
    }
    return updateUrlParams(tempUrl);
  }, [shareableUrl, shareableUrlForSavedObject, updateUrlParams]);
  const getSavedObjectUrl = (0, _react.useCallback)(() => {
    if (isNotSaved()) {
      return;
    }
    const tempUrl = getSnapshotUrl(true);
    const parsedUrl = (0, _url.parse)(tempUrl);
    if (!parsedUrl || !parsedUrl.hash) {
      return;
    }

    // Get the application route, after the hash, and remove the #.
    const parsedAppUrl = (0, _url.parse)(parsedUrl.hash.slice(1), true);
    const formattedUrl = (0, _url.format)({
      protocol: parsedUrl.protocol,
      auth: parsedUrl.auth,
      host: parsedUrl.host,
      pathname: parsedUrl.pathname,
      hash: (0, _url.format)({
        pathname: parsedAppUrl.pathname,
        query: {
          // Add global state to the URL so that the iframe doesn't just show the time range
          // default.
          _g: parsedAppUrl.query._g
        }
      })
    });
    return updateUrlParams(formattedUrl);
  }, [getSnapshotUrl, isNotSaved, updateUrlParams]);
  const createShortUrl = (0, _react.useCallback)(async () => {
    if (shareableUrlLocatorParams) {
      const shortUrls = urlService.shortUrls.get(null);
      const shortUrl = await shortUrls.createWithLocator(shareableUrlLocatorParams);
      const urlWithLoc = await shortUrl.locator.getUrl(shortUrl.params, {
        absolute: true
      });
      setShortUrlCache(urlWithLoc);
      return urlWithLoc;
    } else {
      const snapshotUrl = getSnapshotUrl();
      const shortUrl = await urlService.shortUrls.get(null).createFromLongUrl(snapshotUrl);
      setShortUrlCache(shortUrl.url);
      return shortUrl.url;
    }
  }, [shareableUrlLocatorParams, urlService.shortUrls, getSnapshotUrl, setShortUrlCache]);
  const copyUrlHelper = (0, _react.useCallback)(async () => {
    let urlToCopy = url;
    if (!urlToCopy) {
      let tempUrl = '';
      if (objectType === 'dashboard' || objectType === 'search') {
        tempUrl = getSnapshotUrl();
      } else if (objectType === 'lens') {
        tempUrl = getSavedObjectUrl();
      }
      urlToCopy = allowShortUrl ? await createShortUrl() : tempUrl;
    }
    setUrl(() => {
      (0, _eui.copyToClipboard)(urlToCopy);
      setTextCopied(true);
      return urlToCopy;
    });
  }, [allowShortUrl, createShortUrl, getSavedObjectUrl, getSnapshotUrl, objectType, setUrl, url]);
  const renderSaveState = objectType === 'lens' && isNotSaved() ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.link.lens.saveUrlBox",
    defaultMessage: "There are unsaved changes. Before you generate a link, save the {objectType}.",
    values: {
      objectType
    }
  }) : objectType === 'lens' ? shortUrlCache !== null && shortUrlCache !== void 0 ? shortUrlCache : shareableUrl : (_ref = shareableUrl !== null && shareableUrl !== void 0 ? shareableUrl : shortUrlCache) !== null && _ref !== void 0 ? _ref : '';
  const lensOnClick = () => {
    if (objectType === 'lens' && !isDirty) {
      return copyUrlHelper();
    } else {
      return copyUrlHelper();
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.link.helpText",
    defaultMessage: "Share a direct link to this {objectType}.",
    values: {
      objectType
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), objectType !== 'dashboard' && /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    whiteSpace: "pre",
    css: {
      paddingRight: '30px'
    }
  }, renderSaveState), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isDirty && objectType === 'lens' ? _i18n.i18n.translate('share.link.unsaved', {
      defaultMessage: 'There are unsaved changes. Before you generate a link, save the {objectType}.',
      values: {
        objectType
      }
    }) : isTextCopied ? _i18n.i18n.translate('share.link.copied', {
      defaultMessage: 'Text copied'
    }) : null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "copyShareUrlButton",
    "data-share-url": url,
    onBlur: () => objectType === 'lens' && isDirty ? null : setTextCopied(false),
    onClick: lensOnClick,
    disabled: objectType === 'lens' && isDirty
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.link.copyLinkButton",
    defaultMessage: "Copy link"
  }))))));
};
exports.LinkContent = LinkContent;