"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exportTab = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _export_content = require("./export_content");
var _context = require("../../context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ExportTabContent = () => {
  const {
    shareMenuItems,
    objectType,
    isDirty,
    onClose
  } = (0, _context.useShareTabsContext)();
  return /*#__PURE__*/_react.default.createElement(_export_content.ExportContent, {
    objectType: objectType,
    isDirty: isDirty,
    onClose: onClose,
    aggregateReportTypes: shareMenuItems
  });
};
const exportTab = exports.exportTab = {
  id: 'export',
  name: _i18n.i18n.translate('share.contextMenu.exportCodeTab', {
    defaultMessage: 'Export'
  }),
  content: ExportTabContent
};