"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.embedTab = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _embed_content = require("./embed_content");
var _context = require("../../context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EMBED_TAB_ACTIONS = {
  SET_EMBED_URL: 'SET_EMBED_URL',
  SET_IS_NOT_SAVED: 'SET_IS_NOT_SAVED'
};
const embedTabReducer = (state = {
  url: '',
  isNotSaved: false
}, action) => {
  switch (action.type) {
    case EMBED_TAB_ACTIONS.SET_IS_NOT_SAVED:
      return {
        ...state,
        isNotSaved: action.payload
      };
    default:
      return state;
  }
};
const EmbedTabContent = ({
  state,
  dispatch
}) => {
  const {
    embedUrlParamExtensions,
    shareableUrlForSavedObject,
    shareableUrl,
    isEmbedded,
    objectType,
    isDirty
  } = (0, _context.useShareTabsContext)();
  const setIsNotSaved = (0, _react.useCallback)(() => {
    dispatch({
      type: EMBED_TAB_ACTIONS.SET_IS_NOT_SAVED,
      payload: objectType === 'dashboard' ? isDirty : false
    });
  }, [dispatch, objectType, isDirty]);
  return /*#__PURE__*/_react.default.createElement(_embed_content.EmbedContent, {
    embedUrlParamExtensions,
    shareableUrlForSavedObject,
    shareableUrl,
    isEmbedded,
    objectType,
    isNotSaved: state === null || state === void 0 ? void 0 : state.isNotSaved,
    setIsNotSaved
  });
};
const embedTab = exports.embedTab = {
  id: 'embed',
  name: _i18n.i18n.translate('share.contextMenu.embedCodeTab', {
    defaultMessage: 'Embed'
  }),
  description: _i18n.i18n.translate('share.dashboard.embed.description', {
    defaultMessage: 'Embed this dashboard into another webpage. Select which menu items to include in the embeddable view.'
  }),
  reducer: embedTabReducer,
  content: EmbedTabContent
};