"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportUrlAsType = exports.EmbedContent = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _url = require("url");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
let ExportUrlAsType = exports.ExportUrlAsType = /*#__PURE__*/function (ExportUrlAsType) {
  ExportUrlAsType["EXPORT_URL_AS_SAVED_OBJECT"] = "savedObject";
  ExportUrlAsType["EXPORT_URL_AS_SNAPSHOT"] = "snapshot";
  return ExportUrlAsType;
}({});
const EmbedContent = ({
  embedUrlParamExtensions: urlParamExtensions,
  shareableUrlForSavedObject,
  shareableUrl,
  isEmbedded,
  objectType,
  setIsNotSaved
}) => {
  const isMounted = (0, _useMountedState.default)();
  const [urlParams, setUrlParams] = (0, _react.useState)(undefined);
  const [useShortUrl] = (0, _react.useState)(true);
  const [exportUrlAs] = (0, _react.useState)(ExportUrlAsType.EXPORT_URL_AS_SAVED_OBJECT);
  const [url, setUrl] = (0, _react.useState)('');
  const [shortUrlCache, setShortUrlCache] = (0, _react.useState)(undefined);
  const [anonymousAccessParameters] = (0, _react.useState)(null);
  const [usePublicUrl] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (objectType !== 'dashboard') setIsNotSaved();
  }, [url, setIsNotSaved, objectType]);
  const getUrlParamExtensions = (0, _react.useCallback)(tempUrl => {
    return urlParams ? Object.keys(urlParams).reduce((urlAccumulator, key) => {
      const urlParam = urlParams[key];
      return urlParam ? Object.keys(urlParam).reduce((queryAccumulator, queryParam) => {
        const isQueryParamEnabled = urlParam[queryParam];
        return isQueryParamEnabled ? queryAccumulator + `&${queryParam}=true` : queryAccumulator;
      }, urlAccumulator) : urlAccumulator;
    }, tempUrl) : tempUrl;
  }, [urlParams]);
  const updateUrlParams = (0, _react.useCallback)(tempUrl => {
    tempUrl = urlParams ? getUrlParamExtensions(tempUrl) : tempUrl;
    return tempUrl;
  }, [getUrlParamExtensions, urlParams]);
  const getSnapshotUrl = (0, _react.useCallback)(forSavedObject => {
    let tempUrl = '';
    if (forSavedObject && shareableUrlForSavedObject) {
      tempUrl = shareableUrlForSavedObject;
    }
    if (!tempUrl) {
      tempUrl = shareableUrl || window.location.href;
    }
    return updateUrlParams(tempUrl);
  }, [shareableUrl, shareableUrlForSavedObject, updateUrlParams]);
  const getSavedObjectUrl = (0, _react.useCallback)(() => {
    const tempUrl = getSnapshotUrl(true);
    const parsedUrl = (0, _url.parse)(tempUrl);
    if (!parsedUrl || !parsedUrl.hash) {
      return;
    }

    // Get the application route, after the hash, and remove the #.
    const parsedAppUrl = (0, _url.parse)(parsedUrl.hash.slice(1), true);
    const formattedUrl = (0, _url.format)({
      protocol: parsedUrl.protocol,
      auth: parsedUrl.auth,
      host: parsedUrl.host,
      pathname: parsedUrl.pathname,
      hash: (0, _url.format)({
        pathname: parsedAppUrl.pathname,
        query: {
          // Add global state to the URL so that the iframe doesn't just show the time range
          // default.
          _g: parsedAppUrl.query._g
        }
      })
    });
    return updateUrlParams(formattedUrl);
  }, [getSnapshotUrl, updateUrlParams]);
  const addUrlAnonymousAccessParameters = (0, _react.useCallback)(tempUrl => {
    if (!anonymousAccessParameters || !usePublicUrl) {
      return tempUrl;
    }
    const parsedUrl = new URL(tempUrl);
    for (const [name, value] of Object.entries(anonymousAccessParameters)) {
      parsedUrl.searchParams.set(name, value);
    }
    return parsedUrl.toString();
  }, [anonymousAccessParameters, usePublicUrl]);
  const makeIframeTag = tempUrl => {
    if (!tempUrl) {
      return;
    }
    return `<iframe src="${tempUrl}" height="600" width="800"></iframe>`;
  };
  const setUrlHelper = (0, _react.useCallback)(() => {
    let tempUrl;
    if (exportUrlAs === ExportUrlAsType.EXPORT_URL_AS_SAVED_OBJECT) {
      tempUrl = getSavedObjectUrl();
    } else if (useShortUrl && shortUrlCache) {
      tempUrl = shortUrlCache;
    } else {
      tempUrl = getSnapshotUrl();
    }
    if (tempUrl) {
      tempUrl = addUrlAnonymousAccessParameters(tempUrl);
    }
    if (isEmbedded) {
      tempUrl = makeIframeTag(tempUrl);
    }
    setUrl(tempUrl);
  }, [addUrlAnonymousAccessParameters, exportUrlAs, getSavedObjectUrl, getSnapshotUrl, isEmbedded, shortUrlCache, useShortUrl]);
  const resetUrl = (0, _react.useCallback)(() => {
    if (isMounted()) {
      setShortUrlCache(undefined);
      setUrlHelper();
    }
  }, [isMounted, setUrlHelper]);
  (0, _react.useEffect)(() => {
    setUrlHelper();
    getUrlParamExtensions(url);
    window.addEventListener('hashchange', resetUrl, false);
    isMounted();
  }, [getUrlParamExtensions, resetUrl, setUrlHelper, url, isMounted]);
  const renderUrlParamExtensions = () => {
    if (!urlParamExtensions) {
      return null;
    }
    const setParamValue = paramName => (values = {}) => {
      setUrlParams({
        ...urlParams,
        [paramName]: {
          ...values
        }
      });
      setUrlHelper();
    };
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, urlParamExtensions.map(({
      paramName,
      component: UrlParamComponent
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      key: paramName
    }, /*#__PURE__*/_react.default.createElement(UrlParamComponent, {
      setParamValue: setParamValue(paramName)
    }))));
  };
  const helpText = objectType === 'dashboard' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.embed.dashboard.helpText",
    defaultMessage: "Embed this dashboard into another webpage. Select which items to include in the embeddable view."
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.embed.helpText",
    defaultMessage: "Embed this {objectType} into another webpage.",
    values: {
      objectType
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, helpText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), renderUrlParamExtensions(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: url
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "copyEmbedUrlButton",
    onClick: copy,
    "data-share-url": url,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "share.link.copyEmbedCodeButton",
    defaultMessage: "Copy Embed Code"
  }))))));
};
exports.EmbedContent = EmbedContent;