"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useElasticsearchUrl = void 0;
var _constants = require("../constants");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useElasticsearchUrl = () => {
  var _cloud$elasticsearchU;
  const {
    cloud
  } = (0, _use_kibana.useKibanaServices)();
  return {
    elasticsearchUrl: (_cloud$elasticsearchU = cloud === null || cloud === void 0 ? void 0 : cloud.elasticsearchUrl) !== null && _cloud$elasticsearchU !== void 0 ? _cloud$elasticsearchU : _constants.ELASTICSEARCH_URL_PLACEHOLDER
  };
};
exports.useElasticsearchUrl = useElasticsearchUrl;