"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APIIndexEmptyPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _searchApiPanels = require("@kbn/search-api-panels");
var _i18n_string = require("../../../../common/i18n_string");
var _use_asset_base_path = require("../../hooks/use_asset_base_path");
var _use_kibana = require("../../hooks/use_kibana");
var _java = require("../languages/java");
var _languages = require("../languages/languages");
var _language_grid = require("../languages/language_grid");
var _constants = require("../../constants");
var _api_key = require("../api_key/api_key");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APIIndexEmptyPrompt = ({
  indexName,
  onBackClick
}) => {
  const {
    application,
    cloud,
    share
  } = (0, _use_kibana.useKibanaServices)();
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const [selectedLanguage, setSelectedLanguage] = _react.default.useState(_java.javaDefinition);
  const [clientApiKey, setClientApiKey] = (0, _react.useState)(_constants.API_KEY_PLACEHOLDER);
  const {
    elasticsearchURL,
    cloudId
  } = (0, _react.useMemo)(() => {
    var _cloud$elasticsearchU, _cloud$cloudId;
    return {
      elasticsearchURL: (_cloud$elasticsearchU = cloud === null || cloud === void 0 ? void 0 : cloud.elasticsearchUrl) !== null && _cloud$elasticsearchU !== void 0 ? _cloud$elasticsearchU : _constants.ELASTICSEARCH_URL_PLACEHOLDER,
      cloudId: (_cloud$cloudId = cloud === null || cloud === void 0 ? void 0 : cloud.cloudId) !== null && _cloud$cloudId !== void 0 ? _cloud$cloudId : _constants.CLOUD_ID_PLACEHOLDER
    };
  }, [cloud]);
  const codeSnippetArguments = {
    url: elasticsearchURL,
    apiKey: clientApiKey,
    cloudId,
    indexName
  };
  const apiIngestSteps = [{
    title: _i18n.i18n.translate('xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.api.ingest.title', {
      defaultMessage: 'Ingest data via API using a programming language client'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_language_grid.LanguageGrid, {
      assetBasePath: assetBasePath,
      setSelectedLanguage: setSelectedLanguage,
      languages: _languages.languageDefinitions,
      selectedLanguage: selectedLanguage.id
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
      languages: _languages.languageDefinitions,
      codeSnippet: (0, _searchApiPanels.getLanguageDefinitionCodeSnippet)(selectedLanguage, 'ingestDataIndex', codeSnippetArguments),
      consoleRequest: (0, _searchApiPanels.getConsoleRequest)('ingestDataIndex'),
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage,
      assetBasePath: assetBasePath,
      application: application,
      sharePlugin: share
    })))
  }, {
    title: _i18n.i18n.translate('xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.api.apiKey.title', {
      defaultMessage: 'Prepare an API key'
    }),
    children: /*#__PURE__*/_react.default.createElement(_api_key.ApiKeyPanel, {
      setClientApiKey: setClientApiKey
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "serverlessSearchAPIIndexEmptyPromptBackButton",
    onClick: onBackClick,
    iconSide: "left",
    iconType: "arrowLeft"
  }, _i18n_string.BACK_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "addDataApp",
      size: "xl"
    }),
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.api.title",
      defaultMessage: "Ingest content"
    }))),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.api.body",
      defaultMessage: "Customize these variables to match your content. For a full setup guide, visit our {getStartedLink} guide.",
      values: {
        getStartedLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "serverlessSearchAPIIndexEmptyPromptGetStartedLink",
          onClick: () => application.navigateToApp('elasticsearch')
        }, _i18n.i18n.translate('xpack.serverlessSearch.indexManagement.indexDetails.overview.emptyPrompt.api.body.getStartedLink', {
          defaultMessage: 'Get started'
        }))
      }
    })))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: apiIngestSteps,
    titleSize: "xs"
  }));
};
exports.APIIndexEmptyPrompt = APIIndexEmptyPrompt;