"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_create_connector = require("../hooks/api/use_create_connector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorsCallout = () => {
  const {
    createConnector,
    isLoading
  } = (0, _use_create_connector.useCreateConnector)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.serverlessSearch.selectClient.connectorsCallout.title', {
      defaultMessage: 'Sync your data with a connector client'
    }),
    size: "s",
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.selectClient.connectorsCallout.description",
    defaultMessage: "Sync popular third-party data sources to Elasticsearch using open code connectors on your infrastructure."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    iconType: "plusInCircle",
    "data-test-subj": "connectors-callout-cta",
    onClick: () => createConnector(),
    isLoading: isLoading
  }, _i18n.i18n.translate('xpack.serverlessSearch.selectClient.connectorsCallout.cta', {
    defaultMessage: 'Create a connector'
  })))));
};
exports.ConnectorsCallout = ConnectorsCallout;