"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditServiceType = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("../../hooks/use_kibana");
var _use_connector_types = require("../../hooks/api/use_connector_types");
var _use_connector = require("../../hooks/api/use_connector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditServiceType = ({
  connector
}) => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const connectorTypes = (0, _use_connector_types.useConnectorTypes)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    queryKey
  } = (0, _use_connector.useConnector)(connector.id);
  const options = connectorTypes.map(connectorType => ({
    inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": `serverlessSearchConnectorServiceType-${connectorType.serviceType}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "l",
      title: connectorType.name,
      id: connectorType.serviceType,
      type: connectorType.iconPath
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, connectorType.name)),
    value: connectorType.serviceType
  })) || [];
  const {
    isLoading,
    mutate
  } = (0, _reactQuery.useMutation)({
    mutationFn: async inputServiceType => {
      const body = {
        service_type: inputServiceType
      };
      await http.post(`/internal/serverless_search/connectors/${connector.id}/service_type`, {
        body: JSON.stringify(body)
      });
      return inputServiceType;
    },
    onSuccess: successData => {
      queryClient.setQueryData(queryKey, {
        connector: {
          ...connector,
          service_type: successData
        }
      });
      queryClient.invalidateQueries(queryKey);
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    "data-test-subj": "serverlessSearchEditConnectorTypeLabel"
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.serviceTypeLabel', {
    defaultMessage: 'Connector type'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "serverlessSearchEditConnectorTypeChoices",
    isLoading: isLoading,
    onChange: event => mutate(event),
    options: options,
    valueOfSelected: connector.service_type || undefined
  }));
};
exports.EditServiceType = EditServiceType;