"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncScheduledCallOut = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyncScheduledCallOut = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    iconType: "iInCircle",
    title: _i18n.i18n.translate('xpack.serverlessSearch.connectors.syncScheduledTitle', {
      defaultMessage: 'A sync has been scheduled'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.serverlessSearch.connectors.syncSheduledDescription', {
    defaultMessage: 'It may take a minute for this sync to be visible and for the connector to pick it up'
  })));
};
exports.SyncScheduledCallOut = SyncScheduledCallOut;