"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorOverview = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _reactQuery = require("@tanstack/react-query");
var _react = _interopRequireWildcard(require("react"));
var _use_connector = require("../../../hooks/api/use_connector");
var _use_sync_jobs = require("../../../hooks/api/use_sync_jobs");
var _use_kibana = require("../../../hooks/use_kibana");
var _sync_scheduled_callout = require("./sync_scheduled_callout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorOverview = ({
  connector
}) => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    queryKey
  } = (0, _use_connector.useConnector)(connector.id);
  const {
    data,
    isLoading,
    isSuccess,
    mutate
  } = (0, _reactQuery.useMutation)({
    mutationFn: async () => {
      await http.post(`/internal/serverless_search/connectors/${connector.id}/sync`);
    },
    onSuccess: () => {
      queryClient.setQueryData(queryKey, {
        connector: {
          ...connector,
          index_name: data
        }
      });
      queryClient.invalidateQueries(queryKey);
    }
  });
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0,
    pageSize: 20
  });
  const {
    data: syncJobsData,
    isLoading: syncJobsLoading
  } = (0, _use_sync_jobs.useSyncJobs)(connector.id, pagination);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_searchConnectors.SyncJobsTable, {
    isLoading: syncJobsLoading,
    onPaginate: ({
      page
    }) => setPagination({
      pageIndex: page.index,
      pageSize: page.size
    }),
    pagination: syncJobsData ? (0, _searchConnectors.pageToPagination)(syncJobsData === null || syncJobsData === void 0 ? void 0 : syncJobsData._meta.page) : {
      pageIndex: 0,
      pageSize: 20,
      totalItemCount: 0
    },
    syncJobs: (syncJobsData === null || syncJobsData === void 0 ? void 0 : syncJobsData.data) || [],
    type: "content"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchConnectorOverviewSyncButton",
    color: "primary",
    disabled: [_searchConnectors.ConnectorStatus.CREATED, _searchConnectors.ConnectorStatus.NEEDS_CONFIGURATION].includes(connector.status),
    fill: true,
    isLoading: isLoading,
    onClick: () => mutate()
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.syncLabel', {
    defaultMessage: 'Sync'
  }))), isSuccess && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_sync_scheduled_callout.SyncScheduledCallOut, null)));
};
exports.ConnectorOverview = ConnectorOverview;