"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessObservabilityPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _managementCardsNavigation = require("@kbn/management-cards-navigation");
var _rxjs = require("rxjs");
var _navigation_tree = require("./navigation_tree");
var _overview_registration = require("./logs_signal/overview_registration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServerlessObservabilityPlugin {
  setup(_core, setupDeps) {
    setupDeps.observability.dashboard.register((0, _overview_registration.createObservabilityDashboardRegistration)({
      search: _core.getStartServices().then(([_coreStart, startDeps]) => startDeps.data.search.search)
    }));
    setupDeps.discover.showInlineTopNav({
      showLogsExplorerTabs: true
    });
    return {};
  }
  start(core, setupDeps) {
    const {
      serverless,
      management,
      security
    } = setupDeps;
    const navigationTree$ = (0, _rxjs.of)(_navigation_tree.navigationTree);
    serverless.setProjectHome('/app/observability/landing');
    serverless.initNavigation('oblt', navigationTree$, {
      dataTestSubj: 'svlObservabilitySideNav'
    });
    const extendCardNavDefinitions = serverless.getNavigationCards(security.authz.isRoleManagementEnabled(), {
      observabilityAiAssistantManagement: {
        category: _managementCardsNavigation.appCategories.OTHER,
        title: _i18n.i18n.translate('xpack.serverlessObservability.aiAssistantManagementTitle', {
          defaultMessage: 'AI assistant for Observability settings'
        }),
        description: _i18n.i18n.translate('xpack.serverlessObservability.aiAssistantManagementDescription', {
          defaultMessage: 'Manage your AI assistant for Observability settings.'
        }),
        icon: 'sparkles'
      }
    });
    management.setupCardsNavigation({
      enabled: true,
      hideLinksTo: [_managementCardsNavigation.appIds.RULES],
      extendCardNavDefinitions
    });
    return {};
  }
  stop() {}
}
exports.ServerlessObservabilityPlugin = ServerlessObservabilityPlugin;