"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultValue = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Creates a schema that sets a default value if the input value is not specified.
 *
 * @param valueSchema Base schema of a value.
 * @param value Default value to set.
 * @param name (Optional) Name of the resulting schema.
 */
const defaultValue = (valueSchema, value, name) => {
  return new t.Type(name !== null && name !== void 0 ? name : `DefaultValue<${valueSchema.name}>`, valueSchema.is, (input, context) => input == null ? t.success(value) : valueSchema.validate(input, context), t.identity);
};
exports.defaultValue = defaultValue;