"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readPrivileges = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const readPrivileges = async (esClient, index) => {
  return (await esClient.security.hasPrivileges({
    body: {
      cluster: ['all', 'manage', 'manage_api_key', 'manage_transform', 'manage_index_templates', 'manage_ml', 'manage_own_api_key', 'manage_pipeline', 'manage_security', 'monitor', 'monitor_transform', 'monitor_ml'],
      index: [{
        names: [index],
        privileges: ['all', 'create', 'create_doc', 'create_index', 'delete', 'delete_index', 'index', 'manage', 'maintenance', 'monitor', 'read', 'view_index_metadata', 'write']
      }]
    }
  }, {
    meta: true
  })).body;
};
exports.readPrivileges = readPrivileges;