"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventCode = exports.EventCategory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
let EventCode = exports.EventCode = /*#__PURE__*/function (EventCode) {
  EventCode["MALICIOUS_FILE"] = "malicious_file";
  EventCode["RANSOMWARE"] = "ransomware";
  EventCode["MEMORY_SIGNATURE"] = "memory_signature";
  EventCode["SHELLCODE_THREAD"] = "shellcode_thread";
  EventCode["BEHAVIOR"] = "behavior";
  return EventCode;
}({});
let EventCategory = exports.EventCategory = /*#__PURE__*/function (EventCategory) {
  EventCategory["PROCESS"] = "process";
  EventCategory["FILE"] = "file";
  EventCategory["NETWORK"] = "network";
  EventCategory["REGISTRY"] = "registry";
  EventCategory["MALWARE"] = "malware";
  return EventCategory;
}({});