"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityProductTier = exports.getProductProductFeaturesConfigurator = void 0;
var _cases_product_features_config = require("./cases_product_features_config");
var _security_product_features_config = require("./security_product_features_config");
var _assistant_product_features_config = require("./assistant_product_features_config");
var _product = require("../../common/product");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getProductProductFeaturesConfigurator = (enabledProductFeatureKeys, config) => {
  return {
    security: (0, _security_product_features_config.getSecurityProductFeaturesConfigurator)(enabledProductFeatureKeys, config.experimentalFeatures),
    cases: (0, _cases_product_features_config.getCasesProductFeaturesConfigurator)(enabledProductFeatureKeys),
    securityAssistant: (0, _assistant_product_features_config.getSecurityAssistantProductFeaturesConfigurator)(enabledProductFeatureKeys)
  };
};
exports.getProductProductFeaturesConfigurator = getProductProductFeaturesConfigurator;
const getSecurityProductTier = (config, logger) => {
  const securityProductType = config.productTypes.find(productType => productType.product_line === _product.ProductLine.security);
  const tier = securityProductType ? securityProductType.product_tier : 'none';
  if (tier === 'none') {
    logger.error(`Failed to fetch security product tier, config: ${JSON.stringify(config)}`);
  }
  return tier;
};
exports.getSecurityProductTier = getSecurityProductTier;